/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.tree;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Name;
import java.io.PrintWriter;

public class Pretty
extends Tree.Visitor
implements Flags {
    private final boolean sourceOutput;
    PrintWriter out;
    public int width = 4;
    int lmargin = 0;
    Name enclClassName;
    Hashtable docComments = null;
    int prec;

    public Pretty(PrintWriter printWriter, boolean bl) {
        this.out = printWriter;
        this.sourceOutput = bl;
    }

    void align() {
        int n2 = 0;
        while (n2 < this.lmargin) {
            this.out.print(" ");
            ++n2;
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int n2, int n3) {
        if (n3 < n2) {
            this.out.print("(");
        }
    }

    void close(int n2, int n3) {
        if (n3 < n2) {
            this.out.print(")");
        }
    }

    public void print(String string) {
        this.out.print(Convert.escapeUnicode(string));
    }

    public void println() {
        this.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printExpr(Tree tree, int n2) {
        int n3 = this.prec;
        try {
            this.prec = n2;
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                tree.accept(this);
            }
            Object var5_4 = null;
            this.prec = n3;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.prec = n3;
            throw throwable;
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        this.printExpr(tree, -1);
    }

    public void printExprs(List list, String string) {
        if (list.nonEmpty()) {
            this.printExpr((Tree)list.head);
            List list2 = list.tail;
            while (list2.nonEmpty()) {
                this.print(string);
                this.printExpr((Tree)list2.head);
                list2 = list2.tail;
            }
        }
    }

    public void printExprs(List list) {
        this.printExprs(list, ", ");
    }

    public void printStats(List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            this.align();
            this.printStat((Tree)list2.head);
            this.println();
            list2 = list2.tail;
        }
    }

    public void printFlags(long l2) {
        if ((l2 & 0x10000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(l2));
        if ((l2 & 0xFFFL) != 0L) {
            this.print(" ");
        }
    }

    public void printDocComment(Tree tree) {
        String string;
        if (this.docComments != null && (string = (String)this.docComments.get(tree)) != null) {
            this.print("/**");
            this.println();
            int n2 = 0;
            int n3 = Pretty.lineEndPos(string, n2);
            while (n2 < string.length()) {
                this.align();
                this.print(" *");
                if (n2 < string.length() && string.charAt(n2) > ' ') {
                    this.print(" ");
                }
                this.print(string.substring(n2, n3));
                this.println();
                n2 = n3 + 1;
                n3 = Pretty.lineEndPos(string, n2);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String string, int n2) {
        int n3 = string.indexOf(10, n2);
        if (n3 < 0) {
            n3 = string.length();
        }
        return n3;
    }

    public void printBlock(List list) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printUnit(Tree.TopLevel topLevel, Tree.ClassDef classDef) {
        this.docComments = topLevel.docComments;
        this.printDocComment(topLevel);
        if (topLevel.pid != null) {
            this.print("package ");
            this.printExpr(topLevel.pid);
            this.print(";");
            this.println();
        }
        List list = topLevel.defs;
        while (list.nonEmpty() && (classDef == null || ((Tree)list.head).tag == 2)) {
            this.printStat((Tree)list.head);
            this.println();
            list = list.tail;
        }
        if (classDef != null) {
            this.printStat(classDef);
            this.println();
        }
    }

    public void visitTopLevel(Tree.TopLevel topLevel) {
        this.printUnit(topLevel, null);
    }

    public void visitImport(Tree.Import import_) {
        this.print("import ");
        this.printExpr(import_.qualid);
        this.print(";");
        this.println();
    }

    public void visitClassDef(Tree.ClassDef classDef) {
        this.println();
        this.align();
        this.printDocComment(classDef);
        this.printFlags(classDef.flags & 0xFFFFFFFFFFFFFDFFL);
        Name name = this.enclClassName;
        this.enclClassName = classDef.name;
        if ((classDef.flags & 0x200L) != 0L) {
            this.print("interface " + classDef.name);
            if (classDef.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(classDef.implementing);
            }
        } else {
            this.print("class " + classDef.name);
            if (classDef.extending != null) {
                this.print(" extends ");
                this.printExpr(classDef.extending);
            }
            if (classDef.implementing.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(classDef.implementing);
            }
        }
        this.print(" ");
        this.printBlock(classDef.defs);
        this.enclClassName = name;
    }

    public void visitMethodDef(Tree.MethodDef methodDef) {
        if (methodDef.name == methodDef.name.table.init && this.enclClassName == null && this.sourceOutput) {
            return;
        }
        this.println();
        this.align();
        this.printDocComment(methodDef);
        this.printFlags(methodDef.flags);
        if (methodDef.name == methodDef.name.table.init) {
            this.print(this.enclClassName != null ? this.enclClassName.toString() : methodDef.name.toString());
        } else {
            this.printExpr(methodDef.restype);
            this.print(" " + methodDef.name);
        }
        this.print("(");
        this.printExprs(methodDef.params);
        this.print(")");
        if (methodDef.thrown.nonEmpty()) {
            this.print(" throws ");
            this.printExprs(methodDef.thrown);
        }
        if (methodDef.body != null) {
            this.print(" ");
            this.printStat(methodDef.body);
        } else {
            this.print(";");
        }
    }

    public void visitVarDef(Tree.VarDef varDef) {
        if (this.docComments != null && this.docComments.get(varDef) != null) {
            this.println();
            this.align();
        }
        this.printDocComment(varDef);
        this.printFlags(varDef.flags);
        this.printExpr(varDef.vartype);
        this.print(" " + varDef.name);
        if (varDef.init != null) {
            this.print(" = ");
            this.printExpr(varDef.init);
        }
        if (this.prec == -1) {
            this.print(";");
        }
    }

    public void visitSkip(Tree.Skip skip) {
        this.print(";");
    }

    public void visitBlock(Tree.Block block) {
        this.printFlags(block.flags);
        this.printBlock(block.stats);
    }

    public void visitDoLoop(Tree.DoLoop doLoop) {
        this.print("do ");
        this.printStat(doLoop.body);
        this.align();
        this.print(" while ");
        if (doLoop.cond.tag == 28) {
            this.printExpr(doLoop.cond);
        } else {
            this.print("(");
            this.printExpr(doLoop.cond);
            this.print(")");
        }
        this.print(";");
    }

    public void visitWhileLoop(Tree.WhileLoop whileLoop) {
        this.print("while ");
        if (whileLoop.cond.tag == 28) {
            this.printExpr(whileLoop.cond);
        } else {
            this.print("(");
            this.printExpr(whileLoop.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(whileLoop.body);
    }

    public void visitForLoop(Tree.ForLoop forLoop) {
        this.print("for (");
        if (forLoop.init.nonEmpty()) {
            if (((Tree)forLoop.init.head).tag == 5) {
                this.printExpr((Tree)forLoop.init.head);
                List list = forLoop.init.tail;
                while (list.nonEmpty()) {
                    Tree.VarDef varDef = (Tree.VarDef)list.head;
                    this.print(", " + varDef.name + " = ");
                    this.printExpr(varDef.init);
                    list = list.tail;
                }
            } else {
                this.printExprs(forLoop.init);
            }
        }
        this.print("; ");
        if (forLoop.cond != null) {
            this.printExpr(forLoop.cond);
        }
        this.print("; ");
        this.printExprs(forLoop.step);
        this.print(") ");
        this.printStat(forLoop.body);
    }

    public void visitLabelled(Tree.Labelled labelled) {
        this.print(labelled.label + ": ");
        this.printStat(labelled.body);
    }

    public void visitSwitch(Tree.Switch switch_) {
        this.print("switch ");
        if (switch_.selector.tag == 28) {
            this.printExpr(switch_.selector);
        } else {
            this.print("(");
            this.printExpr(switch_.selector);
            this.print(")");
        }
        this.print(" {");
        this.println();
        this.printStats(switch_.cases);
        this.align();
        this.print("}");
    }

    public void visitCase(Tree.Case case_) {
        if (case_.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(case_.pat);
        }
        this.print(": ");
        this.println();
        this.indent();
        this.printStats(case_.stats);
        this.undent();
        this.align();
    }

    public void visitSynchronized(Tree.Synchronized synchronized_) {
        this.print("synchronized ");
        if (synchronized_.lock.tag == 28) {
            this.printExpr(synchronized_.lock);
        } else {
            this.print("(");
            this.printExpr(synchronized_.lock);
            this.print(")");
        }
        this.print(" ");
        this.printStat(synchronized_.body);
    }

    public void visitTry(Tree.Try try_) {
        this.print("try ");
        this.printStat(try_.body);
        List list = try_.catchers;
        while (list.nonEmpty()) {
            this.printStat((Tree)list.head);
            list = list.tail;
        }
        if (try_.finalizer != null) {
            this.print(" finally ");
            this.printStat(try_.finalizer);
        }
    }

    public void visitCatch(Tree.Catch catch_) {
        this.print(" catch (");
        this.printExpr(catch_.param);
        this.print(") ");
        this.printStat(catch_.body);
    }

    public void visitConditional(Tree.Conditional conditional) {
        this.open(this.prec, 3);
        this.printExpr(conditional.cond, 3);
        this.print(" ? ");
        this.printExpr(conditional.truepart, 3);
        this.print(" : ");
        this.printExpr(conditional.falsepart, 3);
        this.close(this.prec, 3);
    }

    public void visitIf(Tree.If if_) {
        this.print("if ");
        if (if_.cond.tag == 28) {
            this.printExpr(if_.cond);
        } else {
            this.print("(");
            this.printExpr(if_.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(if_.thenpart);
        if (if_.elsepart != null) {
            this.print(" else ");
            this.printStat(if_.elsepart);
        }
    }

    public void visitExec(Tree.Exec exec) {
        this.printExpr(exec.expr);
        if (this.prec == -1) {
            this.print(";");
        }
    }

    public void visitBreak(Tree.Break break_) {
        this.print("break");
        if (break_.label != null) {
            this.print(" " + break_.label);
        }
        this.print(";");
    }

    public void visitContinue(Tree.Continue continue_) {
        this.print("continue");
        if (continue_.label != null) {
            this.print(" " + continue_.label);
        }
        this.print(";");
    }

    public void visitReturn(Tree.Return return_) {
        this.print("return");
        if (return_.expr != null) {
            this.print(" ");
            this.printExpr(return_.expr);
        }
        this.print(";");
    }

    public void visitThrow(Tree.Throw throw_) {
        this.print("throw ");
        this.printExpr(throw_.expr);
        this.print(";");
    }

    public void visitAssert(Tree.Assert assert_) {
        this.print("assert ");
        this.printExpr(assert_.cond);
        if (assert_.detail != null) {
            this.print(" : ");
            this.printExpr(assert_.detail);
        }
        this.print(";");
    }

    public void visitApply(Tree.Apply apply) {
        this.printExpr(apply.meth);
        this.print("(");
        this.printExprs(apply.args);
        this.print(")");
    }

    public void visitNewClass(Tree.NewClass newClass) {
        if (newClass.encl != null) {
            this.printExpr(newClass.encl);
            this.print(".");
        }
        this.print("new ");
        this.printExpr(newClass.clazz);
        this.print("(");
        this.printExprs(newClass.args);
        this.print(")");
        if (newClass.def != null) {
            Name name = this.enclClassName;
            this.enclClassName = null;
            this.printBlock(newClass.def.defs);
            this.enclClassName = name;
        }
    }

    public void visitNewArray(Tree.NewArray newArray) {
        if (newArray.elemtype != null) {
            this.print("new ");
            int n2 = 0;
            Tree tree = newArray.elemtype;
            while (tree.tag == 37) {
                ++n2;
                tree = ((Tree.TypeArray)tree).elemtype;
            }
            this.printExpr(tree);
            List list = newArray.dims;
            while (list.nonEmpty()) {
                this.print("[");
                this.printExpr((Tree)list.head);
                this.print("]");
                list = list.tail;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.print("[]");
                ++n3;
            }
            if (newArray.elems != null) {
                this.print("[]");
            }
        }
        if (newArray.elems != null) {
            this.print("{");
            this.printExprs(newArray.elems);
            this.print("}");
        }
    }

    public void visitParens(Tree.Parens parens) {
        this.print("(");
        this.printExpr(parens.expr);
        this.print(")");
    }

    public void visitAssign(Tree.Assign assign) {
        this.open(this.prec, 1);
        this.printExpr(assign.lhs, 2);
        this.print(" = ");
        this.printExpr(assign.rhs, 1);
        this.close(this.prec, 1);
    }

    public String operatorName(int n2) {
        switch (n2) {
            case 41: {
                return "+";
            }
            case 42: {
                return "-";
            }
            case 43: {
                return "!";
            }
            case 44: {
                return "~";
            }
            case 45: {
                return "++";
            }
            case 46: {
                return "--";
            }
            case 47: {
                return "++";
            }
            case 48: {
                return "--";
            }
            case 49: {
                return "<*nullchk*>";
            }
            case 50: {
                return "||";
            }
            case 51: {
                return "&&";
            }
            case 55: {
                return "==";
            }
            case 56: {
                return "!=";
            }
            case 57: {
                return "<";
            }
            case 58: {
                return ">";
            }
            case 59: {
                return "<=";
            }
            case 60: {
                return ">=";
            }
            case 52: {
                return "|";
            }
            case 53: {
                return "^";
            }
            case 54: {
                return "&";
            }
            case 61: {
                return "<<";
            }
            case 62: {
                return ">>";
            }
            case 63: {
                return ">>>";
            }
            case 64: {
                return "+";
            }
            case 65: {
                return "-";
            }
            case 66: {
                return "*";
            }
            case 67: {
                return "/";
            }
            case 68: {
                return "%";
            }
        }
        throw new Error();
    }

    public void visitAssignop(Tree.Assignop assignop) {
        this.open(this.prec, 2);
        this.printExpr(assignop.lhs, 3);
        this.print(" " + this.operatorName(assignop.tag - 17) + "= ");
        this.printExpr(assignop.rhs, 2);
        this.close(this.prec, 2);
    }

    public void visitUnary(Tree.Unary unary) {
        int n2 = TreeInfo.opPrec(unary.tag);
        String string = this.operatorName(unary.tag).toString();
        this.open(this.prec, n2);
        if (unary.tag <= 46) {
            this.print(string);
            this.printExpr(unary.arg, n2);
        } else {
            this.printExpr(unary.arg, n2);
            this.print(string);
        }
        this.close(this.prec, n2);
    }

    public void visitBinary(Tree.Binary binary) {
        int n2 = TreeInfo.opPrec(binary.tag);
        String string = this.operatorName(binary.tag).toString();
        this.open(this.prec, n2);
        this.printExpr(binary.lhs, n2);
        this.print(" " + string + " ");
        this.printExpr(binary.rhs, n2 + 1);
        this.close(this.prec, n2);
    }

    public void visitTypeCast(Tree.TypeCast typeCast) {
        this.open(this.prec, 14);
        this.print("(");
        this.printExpr(typeCast.clazz);
        this.print(")");
        this.printExpr(typeCast.expr, 14);
        this.close(this.prec, 14);
    }

    public void visitTypeTest(Tree.TypeTest typeTest) {
        this.open(this.prec, 10);
        this.printExpr(typeTest.expr, 10);
        this.print(" instanceof ");
        this.printExpr(typeTest.clazz, 11);
        this.close(this.prec, 10);
    }

    public void visitIndexed(Tree.Indexed indexed) {
        this.printExpr(indexed.indexed, 15);
        this.print("[");
        this.printExpr(indexed.index);
        this.print("]");
    }

    public void visitSelect(Tree.Select select) {
        this.printExpr(select.selected, 15);
        this.print("." + select.name);
    }

    public void visitIdent(Tree.Ident ident) {
        this.print(ident.name.toString());
    }

    public void visitLiteral(Tree.Literal literal) {
        switch (literal.typetag) {
            case 4: {
                this.print(literal.value.toString());
                break;
            }
            case 5: {
                this.print(literal.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(literal.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(literal.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)literal.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.print("\"" + Convert.quote((String)literal.value) + "\"");
                break;
            }
            default: {
                this.print(literal.value.toString());
            }
        }
    }

    public void visitTypeIdent(Tree.TypeIdent typeIdent) {
        switch (typeIdent.typetag) {
            case 1: {
                this.print("byte");
                break;
            }
            case 2: {
                this.print("char");
                break;
            }
            case 3: {
                this.print("short");
                break;
            }
            case 4: {
                this.print("int");
                break;
            }
            case 5: {
                this.print("long");
                break;
            }
            case 6: {
                this.print("float");
                break;
            }
            case 7: {
                this.print("double");
                break;
            }
            case 8: {
                this.print("boolean");
                break;
            }
            case 9: {
                this.print("void");
                break;
            }
            default: {
                this.print("error");
            }
        }
    }

    public void visitTypeArray(Tree.TypeArray typeArray) {
        this.printExpr(typeArray.elemtype);
        this.print("[]");
    }

    public void visitErroneous(Tree.Erroneous erroneous) {
        this.print("(ERROR)");
    }

    public void visitTree(Tree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.println();
    }
}

