/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;

class ExceptionSpec
extends EventRequestSpec {
    private boolean notifyCaught;
    private boolean notifyUncaught;

    private ExceptionSpec(ReferenceTypeSpec referenceTypeSpec) {
        this(referenceTypeSpec, true, true);
    }

    ExceptionSpec(ReferenceTypeSpec referenceTypeSpec, boolean bl, boolean bl2) {
        super(referenceTypeSpec);
        this.notifyCaught = bl;
        this.notifyUncaught = bl2;
    }

    EventRequest resolveEventRequest(ReferenceType referenceType) {
        EventRequestManager eventRequestManager = referenceType.virtualMachine().eventRequestManager();
        ExceptionRequest exceptionRequest = eventRequestManager.createExceptionRequest(referenceType, this.notifyCaught, this.notifyUncaught);
        exceptionRequest.enable();
        return exceptionRequest;
    }

    public boolean notifyCaught() {
        return this.notifyCaught;
    }

    public boolean notifyUncaught() {
        return this.notifyUncaught;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + (this.notifyCaught() ? 0 : 1);
        n2 = 37 * n2 + (this.notifyUncaught() ? 0 : 1);
        n2 = 37 * n2 + this.refSpec.hashCode();
        return n2;
    }

    public boolean equals(Object object) {
        if (object instanceof ExceptionSpec) {
            ExceptionSpec exceptionSpec = (ExceptionSpec)object;
            if (this.refSpec.equals(exceptionSpec.refSpec) && this.notifyCaught() == exceptionSpec.notifyCaught() && this.notifyUncaught() == exceptionSpec.notifyUncaught()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = this.notifyCaught && !this.notifyUncaught ? MessageOutput.format("exceptionSpec caught", this.refSpec.toString()) : (this.notifyUncaught && !this.notifyCaught ? MessageOutput.format("exceptionSpec uncaught", this.refSpec.toString()) : MessageOutput.format("exceptionSpec all", this.refSpec.toString()));
        return string;
    }
}

