/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.tty.AccessWatchpointSpec;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ModificationWatchpointSpec;
import com.sun.tools.example.debug.tty.PatternReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class EventRequestSpecList {
    private static final int statusResolved = 1;
    private static final int statusUnresolved = 2;
    private static final int statusError = 3;
    private List eventRequestSpecs = Collections.synchronizedList(new ArrayList());

    EventRequestSpecList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resolve(ClassPrepareEvent classPrepareEvent) {
        boolean bl = false;
        List list = this.eventRequestSpecs;
        synchronized (list) {
            Iterator iterator = this.eventRequestSpecs.iterator();
            while (iterator.hasNext()) {
                EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
                if (eventRequestSpec.isResolved()) continue;
                try {
                    EventRequest eventRequest = eventRequestSpec.resolve(classPrepareEvent);
                    if (eventRequest == null) continue;
                    MessageOutput.println("Set deferred", eventRequestSpec.toString());
                }
                catch (Exception exception) {
                    MessageOutput.println("Unable to set deferred", new Object[]{eventRequestSpec.toString(), eventRequestSpec.errorMessageFor(exception)});
                    bl = true;
                }
            }
        }
        return !bl;
    }

    void resolveAll() {
        Iterator iterator = this.eventRequestSpecs.iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            try {
                EventRequest eventRequest = eventRequestSpec.resolveEagerly();
                if (eventRequest == null) continue;
                MessageOutput.println("Set deferred", eventRequestSpec.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    boolean addEagerlyResolve(EventRequestSpec eventRequestSpec) {
        try {
            this.eventRequestSpecs.add(eventRequestSpec);
            EventRequest eventRequest = eventRequestSpec.resolveEagerly();
            if (eventRequest != null) {
                MessageOutput.println("Set", eventRequestSpec.toString());
            }
            return true;
        }
        catch (Exception exception) {
            MessageOutput.println("Unable to set", new Object[]{eventRequestSpec.toString(), eventRequestSpec.errorMessageFor(exception)});
            return false;
        }
    }

    void add(EventRequestSpec eventRequestSpec) {
        this.eventRequestSpecs.add(eventRequestSpec);
    }

    EventRequestSpec createBreakpoint(String string, int n2) throws ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new BreakpointSpec(patternReferenceTypeSpec, n2);
    }

    EventRequestSpec createBreakpoint(String string, String string2, List list) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new BreakpointSpec(patternReferenceTypeSpec, string2, list);
    }

    EventRequestSpec createExceptionCatch(String string, boolean bl, boolean bl2) throws ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ExceptionSpec(patternReferenceTypeSpec, bl, bl2);
    }

    EventRequestSpec createAccessWatchpoint(String string, String string2) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new AccessWatchpointSpec(patternReferenceTypeSpec, string2);
    }

    EventRequestSpec createModificationWatchpoint(String string, String string2) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec patternReferenceTypeSpec = new PatternReferenceTypeSpec(string);
        return new ModificationWatchpointSpec(patternReferenceTypeSpec, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(EventRequestSpec eventRequestSpec) {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            int n2 = this.eventRequestSpecs.indexOf(eventRequestSpec);
            if (n2 != -1) {
                EventRequestSpec eventRequestSpec2 = (EventRequestSpec)this.eventRequestSpecs.get(n2);
                this.eventRequestSpecs.remove(n2);
                if (eventRequestSpec2.isResolved()) {
                    Env.vm().eventRequestManager().deleteEventRequest(eventRequestSpec2.resolved());
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List eventRequestSpecs() {
        List list = this.eventRequestSpecs;
        synchronized (list) {
            return new ArrayList(this.eventRequestSpecs);
        }
    }
}

