/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventNotifier;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadInfo;

public class EventHandler
implements Runnable {
    EventNotifier notifier;
    Thread thread;
    volatile boolean connected = true;
    boolean completed = false;
    String shutdownMessageKey;
    boolean stopOnVMStart;
    private boolean vmDied = false;

    EventHandler(EventNotifier eventNotifier, boolean bl) {
        this.notifier = eventNotifier;
        this.stopOnVMStart = bl;
        this.thread = new Thread((Runnable)this, "event-handler");
        this.thread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        EventQueue eventQueue = Env.vm().eventQueue();
        while (this.connected) {
            try {
                object = eventQueue.remove();
                boolean bl = false;
                EventIterator eventIterator = object.eventIterator();
                while (eventIterator.hasNext()) {
                    bl |= !this.handleEvent(eventIterator.nextEvent());
                }
                if (bl) {
                    object.resume();
                    continue;
                }
                if (object.suspendPolicy() != 2) continue;
                this.setCurrentThread((EventSet)object);
                this.notifier.vmInterrupted();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.handleDisconnectedException();
                break;
            }
        }
        object = this;
        synchronized (object) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private boolean handleEvent(Event event) {
        this.notifier.receivedEvent(event);
        if (event instanceof ExceptionEvent) {
            return this.exceptionEvent(event);
        }
        if (event instanceof BreakpointEvent) {
            return this.breakpointEvent(event);
        }
        if (event instanceof WatchpointEvent) {
            return this.fieldWatchEvent(event);
        }
        if (event instanceof StepEvent) {
            return this.stepEvent(event);
        }
        if (event instanceof MethodEntryEvent) {
            return this.methodEntryEvent(event);
        }
        if (event instanceof MethodExitEvent) {
            return this.methodExitEvent(event);
        }
        if (event instanceof ClassPrepareEvent) {
            return this.classPrepareEvent(event);
        }
        if (event instanceof ClassUnloadEvent) {
            return this.classUnloadEvent(event);
        }
        if (event instanceof ThreadStartEvent) {
            return this.threadStartEvent(event);
        }
        if (event instanceof ThreadDeathEvent) {
            return this.threadDeathEvent(event);
        }
        if (event instanceof VMStartEvent) {
            return this.vmStartEvent(event);
        }
        return this.handleExitEvent(event);
    }

    private boolean handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.vmDied = true;
            return this.vmDeathEvent(event);
        }
        if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            if (!this.vmDied) {
                this.vmDisconnectEvent(event);
            }
            Env.shutdown(this.shutdownMessageKey);
            return false;
        }
        throw new InternalError(MessageOutput.format("Unexpected event type"));
    }

    synchronized void handleDisconnectedException() {
        EventQueue eventQueue = Env.vm().eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = eventQueue.remove();
                EventIterator eventIterator = eventSet.eventIterator();
                while (eventIterator.hasNext()) {
                    this.handleExitEvent((Event)eventIterator.next());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private ThreadReference eventThread(Event event) {
        if (event instanceof ClassPrepareEvent) {
            return ((ClassPrepareEvent)event).thread();
        }
        if (event instanceof LocatableEvent) {
            return ((LocatableEvent)event).thread();
        }
        if (event instanceof ThreadStartEvent) {
            return ((ThreadStartEvent)event).thread();
        }
        if (event instanceof ThreadDeathEvent) {
            return ((ThreadDeathEvent)event).thread();
        }
        if (event instanceof VMStartEvent) {
            return ((VMStartEvent)event).thread();
        }
        return null;
    }

    private void setCurrentThread(EventSet eventSet) {
        ThreadReference threadReference;
        if (eventSet.size() > 0) {
            Event event = (Event)eventSet.iterator().next();
            threadReference = this.eventThread(event);
        } else {
            threadReference = null;
        }
        this.setCurrentThread(threadReference);
    }

    private void setCurrentThread(ThreadReference threadReference) {
        ThreadInfo.invalidateAll();
        ThreadInfo.setCurrentThread(threadReference);
    }

    private boolean vmStartEvent(Event event) {
        VMStartEvent vMStartEvent = (VMStartEvent)event;
        this.notifier.vmStartEvent(vMStartEvent);
        return this.stopOnVMStart;
    }

    private boolean breakpointEvent(Event event) {
        BreakpointEvent breakpointEvent = (BreakpointEvent)event;
        this.notifier.breakpointEvent(breakpointEvent);
        return true;
    }

    private boolean methodEntryEvent(Event event) {
        MethodEntryEvent methodEntryEvent = (MethodEntryEvent)event;
        this.notifier.methodEntryEvent(methodEntryEvent);
        return true;
    }

    private boolean methodExitEvent(Event event) {
        MethodExitEvent methodExitEvent = (MethodExitEvent)event;
        this.notifier.methodExitEvent(methodExitEvent);
        return true;
    }

    private boolean fieldWatchEvent(Event event) {
        WatchpointEvent watchpointEvent = (WatchpointEvent)event;
        this.notifier.fieldWatchEvent(watchpointEvent);
        return true;
    }

    private boolean stepEvent(Event event) {
        StepEvent stepEvent = (StepEvent)event;
        this.notifier.stepEvent(stepEvent);
        return true;
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent classPrepareEvent = (ClassPrepareEvent)event;
        this.notifier.classPrepareEvent(classPrepareEvent);
        if (!Env.specList.resolve(classPrepareEvent)) {
            MessageOutput.lnprint("Stopping due to deferred breakpoint errors.");
            return true;
        }
        return false;
    }

    private boolean classUnloadEvent(Event event) {
        ClassUnloadEvent classUnloadEvent = (ClassUnloadEvent)event;
        this.notifier.classUnloadEvent(classUnloadEvent);
        return false;
    }

    private boolean exceptionEvent(Event event) {
        ExceptionEvent exceptionEvent = (ExceptionEvent)event;
        this.notifier.exceptionEvent(exceptionEvent);
        return true;
    }

    private boolean threadDeathEvent(Event event) {
        ThreadDeathEvent threadDeathEvent = (ThreadDeathEvent)event;
        ThreadInfo.removeThread(threadDeathEvent.thread());
        return false;
    }

    private boolean threadStartEvent(Event event) {
        ThreadStartEvent threadStartEvent = (ThreadStartEvent)event;
        ThreadInfo.addThread(threadStartEvent.thread());
        this.notifier.threadStartEvent(threadStartEvent);
        return false;
    }

    public boolean vmDeathEvent(Event event) {
        this.shutdownMessageKey = "The application exited";
        this.notifier.vmDeathEvent((VMDeathEvent)event);
        return false;
    }

    public boolean vmDisconnectEvent(Event event) {
        this.shutdownMessageKey = "The application has been disconnected";
        this.notifier.vmDisconnectEvent((VMDisconnectEvent)event);
        return false;
    }
}

