/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadGroupIterator;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.ThreadIterator;
import com.sun.tools.example.debug.tty.VMConnection;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import com.sun.tools.example.debug.tty.WatchpointSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class Commands {
    Commands() {
    }

    private Value evaluate(String string) {
        Value value;
        block7: {
            value = null;
            ExpressionParser.GetFrame getFrame = null;
            try {
                final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
                if (threadInfo != null && threadInfo.getCurrentFrame() != null) {
                    getFrame = new ExpressionParser.GetFrame(){

                        public StackFrame get() throws IncompatibleThreadStateException {
                            return threadInfo.getCurrentFrame();
                        }
                    };
                }
                value = ExpressionParser.evaluate(string, Env.vm(), getFrame);
            }
            catch (InvocationException invocationException) {
                MessageOutput.println("Exception in expression:", invocationException.exception().referenceType().name());
            }
            catch (Exception exception) {
                String string2;
                String string3 = exception.getMessage();
                if (string3 == null) {
                    MessageOutput.printException(string3, exception);
                    break block7;
                }
                try {
                    string2 = MessageOutput.format(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = exception.toString();
                }
                MessageOutput.printDirectln(string2);
            }
        }
        return value;
    }

    private ThreadInfo doGetThread(String string) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(string);
        if (threadInfo == null) {
            MessageOutput.println("is not a valid thread id", string);
        }
        return threadInfo;
    }

    String typedName(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.name());
        stringBuffer.append("(");
        Iterator iterator = method.argumentTypeNames().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    void commandClasses() {
        List list = Env.vm().allClasses();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < list.size()) {
            ReferenceType referenceType = (ReferenceType)list.get(n2);
            stringBuffer.append(referenceType.name());
            stringBuffer.append("\n");
            ++n2;
        }
        MessageOutput.print("** classes list **", stringBuffer.toString());
    }

    void commandClass(StringTokenizer stringTokenizer) {
        ReferenceType referenceType;
        List list = Env.vm().allClasses();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            if (stringTokenizer.nextToken().toLowerCase().equals("all")) {
                bl = true;
            } else {
                MessageOutput.println("Invalid option on class command");
                return;
            }
        }
        if ((referenceType = Env.getReferenceTypeFromToken(string)) == null) {
            MessageOutput.println("is not a valid id or class name", string);
            return;
        }
        if (referenceType instanceof ClassType) {
            Object object;
            Object object2;
            ClassType classType = (ClassType)referenceType;
            MessageOutput.println("Class:", classType.name());
            ClassType classType2 = classType.superclass();
            while (classType2 != null) {
                MessageOutput.println("extends:", classType2.name());
                ClassType classType3 = classType2 = bl ? classType2.superclass() : null;
            }
            List list2 = bl ? classType.allInterfaces() : classType.interfaces();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                object2 = (InterfaceType)iterator.next();
                MessageOutput.println("implements:", object2.name());
            }
            object2 = classType.subclasses();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ClassType)iterator.next();
                MessageOutput.println("subclass:", object.name());
            }
            object = classType.nestedTypes();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType2 = (ReferenceType)iterator.next();
                MessageOutput.println("nested:", referenceType2.name());
            }
        } else if (referenceType instanceof InterfaceType) {
            Object object;
            Object object3;
            Object object4;
            InterfaceType interfaceType = (InterfaceType)referenceType;
            MessageOutput.println("Interface:", interfaceType.name());
            List list3 = interfaceType.superinterfaces();
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                object4 = (InterfaceType)iterator.next();
                MessageOutput.println("extends:", object4.name());
            }
            object4 = interfaceType.subinterfaces();
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                object3 = (InterfaceType)iterator.next();
                MessageOutput.println("subinterface:", object3.name());
            }
            object3 = interfaceType.implementors();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                object = (ClassType)iterator.next();
                MessageOutput.println("implementor:", object.name());
            }
            object = interfaceType.nestedTypes();
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType3 = (ReferenceType)iterator.next();
                MessageOutput.println("nested:", referenceType3.name());
            }
        } else {
            ArrayType arrayType = (ArrayType)referenceType;
            MessageOutput.println("Array:", arrayType.name());
        }
    }

    void commandMethods(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List list = referenceType.allMethods();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < list.size()) {
                Method method = (Method)list.get(n2);
                stringBuffer.append(method.declaringType().name());
                stringBuffer.append(" ");
                stringBuffer.append(method.name());
                stringBuffer.append("(");
                Iterator iterator = method.argumentTypeNames().iterator();
                if (iterator.hasNext()) {
                    while (true) {
                        stringBuffer.append((String)iterator.next());
                        if (!iterator.hasNext()) break;
                        stringBuffer.append(", ");
                    }
                }
                stringBuffer.append(")\n");
                ++n2;
            }
            MessageOutput.print("** methods list **", stringBuffer.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    void commandFields(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        if (referenceType != null) {
            List list = referenceType.allFields();
            List list2 = referenceType.visibleFields();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < list.size()) {
                Field field = (Field)list.get(n2);
                String string2 = !list2.contains(field) ? MessageOutput.format("list field typename and name hidden", new Object[]{field.typeName(), field.name()}) : (!field.declaringType().equals(referenceType) ? MessageOutput.format("list field typename and name inherited", new Object[]{field.typeName(), field.name(), field.declaringType().name()}) : MessageOutput.format("list field typename and name", new Object[]{field.typeName(), field.name()}));
                stringBuffer.append(string2);
                ++n2;
            }
            MessageOutput.print("** fields list **", stringBuffer.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    private void printThreadGroup(ThreadGroupReference threadGroupReference) {
        ThreadReference threadReference;
        ThreadIterator threadIterator = new ThreadIterator(threadGroupReference);
        MessageOutput.println("Thread Group:", threadGroupReference.name());
        int n2 = 0;
        int n3 = 0;
        while (threadIterator.hasNext()) {
            threadReference = (ThreadReference)threadIterator.next();
            n2 = Math.max(n2, Env.description(threadReference).length());
            n3 = Math.max(n3, threadReference.name().length());
        }
        threadIterator = new ThreadIterator(threadGroupReference);
        while (threadIterator.hasNext()) {
            String string;
            threadReference = (ThreadReference)threadIterator.next();
            if (!threadReference.threadGroup().equals(threadGroupReference)) {
                threadGroupReference = threadReference.threadGroup();
                MessageOutput.println("Thread Group:", threadGroupReference.name());
            }
            StringBuffer stringBuffer = new StringBuffer(Env.description(threadReference));
            int n4 = stringBuffer.length();
            while (n4 < n2) {
                stringBuffer.append(" ");
                ++n4;
            }
            StringBuffer stringBuffer2 = new StringBuffer(threadReference.name());
            int n5 = stringBuffer2.length();
            while (n5 < n3) {
                stringBuffer2.append(" ");
                ++n5;
            }
            switch (threadReference.status()) {
                case -1: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name unknownStatus BP";
                        break;
                    }
                    string = "Thread description name unknownStatus";
                    break;
                }
                case 0: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name zombieStatus BP";
                        break;
                    }
                    string = "Thread description name zombieStatus";
                    break;
                }
                case 1: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name runningStatus BP";
                        break;
                    }
                    string = "Thread description name runningStatus";
                    break;
                }
                case 2: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name sleepingStatus BP";
                        break;
                    }
                    string = "Thread description name sleepingStatus";
                    break;
                }
                case 3: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name waitingStatus BP";
                        break;
                    }
                    string = "Thread description name waitingStatus";
                    break;
                }
                case 4: {
                    if (threadReference.isAtBreakpoint()) {
                        string = "Thread description name condWaitstatus BP";
                        break;
                    }
                    string = "Thread description name condWaitstatus";
                    break;
                }
                default: {
                    throw new InternalError(MessageOutput.format("Invalid thread status."));
                }
            }
            MessageOutput.println(string, new Object[]{stringBuffer.toString(), stringBuffer2.toString()});
        }
    }

    void commandThreads(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.printThreadGroup(ThreadInfo.group());
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            MessageOutput.println("is not a valid threadgroup name", string);
        } else {
            this.printThreadGroup(threadGroupReference);
        }
    }

    void commandThreadGroups() {
        ThreadGroupIterator threadGroupIterator = new ThreadGroupIterator();
        int n2 = 0;
        while (threadGroupIterator.hasNext()) {
            ThreadGroupReference threadGroupReference = threadGroupIterator.nextThreadGroup();
            MessageOutput.println("thread group number description name", new Object[]{new Integer(++n2), Env.description(threadGroupReference), threadGroupReference.name()});
        }
    }

    void commandThread(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Thread number not specified.");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
        if (threadInfo != null) {
            ThreadInfo.setCurrentThreadInfo(threadInfo);
        }
    }

    void commandThreadGroup(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Threadgroup name not specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ThreadGroupReference threadGroupReference = ThreadGroupIterator.find(string);
        if (threadGroupReference == null) {
            MessageOutput.println("is not a valid threadgroup name", string);
        } else {
            ThreadInfo.setThreadGroup(threadGroupReference);
        }
    }

    void commandRun(StringTokenizer stringTokenizer) {
        String string;
        VMConnection vMConnection = Env.connection();
        if (!vMConnection.isLaunch()) {
            if (!stringTokenizer.hasMoreTokens()) {
                this.commandCont();
            } else {
                MessageOutput.println("run <args> command is valid only with launched VMs");
            }
            return;
        }
        if (vMConnection.isOpen()) {
            MessageOutput.println("VM already running. use cont to continue after events.");
            return;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken("");
            boolean bl = vMConnection.setConnectorArg("main", string);
            if (!bl) {
                MessageOutput.println("Unable to set main class and arguments");
                return;
            }
        } else {
            string = vMConnection.connectorArg("main");
            if (string.length() == 0) {
                MessageOutput.println("Main class and arguments must be specified");
                return;
            }
        }
        MessageOutput.println("run", string);
        vMConnection.open();
    }

    void commandLoad(StringTokenizer stringTokenizer) {
        MessageOutput.println("The load command is no longer supported.");
    }

    private List allThreads(ThreadGroupReference threadGroupReference) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(threadGroupReference.threads());
        Iterator iterator = threadGroupReference.threadGroups().iterator();
        while (iterator.hasNext()) {
            ThreadGroupReference threadGroupReference2 = (ThreadGroupReference)iterator.next();
            arrayList.addAll(this.allThreads(threadGroupReference2));
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    void commandSuspend(StringTokenizer var1_1) {
        block1: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl8
            Env.vm().suspend();
            MessageOutput.println("All threads suspended.");
            break block1;
lbl-1000:
            // 1 sources

            {
                var2_2 = this.doGetThread(var1_1.nextToken());
                if (var2_2 == null) continue;
                var2_2.getThread().suspend();
lbl8:
                // 3 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void commandResume(StringTokenizer var1_1) {
        block1: {
            if (var1_1.hasMoreTokens()) ** GOTO lbl10
            ThreadInfo.invalidateAll();
            Env.vm().resume();
            MessageOutput.println("All threads resumed.");
            break block1;
lbl-1000:
            // 1 sources

            {
                var2_2 = this.doGetThread(var1_1.nextToken());
                if (var2_2 == null) continue;
                var2_2.invalidate();
                var2_2.getThread().resume();
lbl10:
                // 3 sources

                ** while (var1_1.hasMoreTokens())
            }
        }
    }

    void commandCont() {
        if (ThreadInfo.getCurrentThreadInfo() == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void clearPreviousStep(ThreadReference threadReference) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        List list = eventRequestManager.stepRequests();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StepRequest stepRequest = (StepRequest)iterator.next();
            if (!stepRequest.thread().equals(threadReference)) continue;
            eventRequestManager.deleteEventRequest(stepRequest);
            break;
        }
    }

    void commandStep(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        int n2 = stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().toLowerCase().equals("up") ? 3 : 1;
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -2, n2);
        if (n2 == 1) {
            Env.addExcludes(stepRequest);
        }
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandStepi() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -1, 1);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandNext() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        StepRequest stepRequest = eventRequestManager.createStepRequest(threadInfo.getThread(), -2, 2);
        Env.addExcludes(stepRequest);
        stepRequest.addCountFilter(1);
        stepRequest.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void doKill(ThreadReference threadReference, StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No exception object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            try {
                threadReference.stop((ObjectReference)value);
                MessageOutput.println("killed", threadReference.toString());
            }
            catch (InvalidTypeException invalidTypeException) {
                MessageOutput.println("Invalid exception object");
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void doKillThread(final ThreadReference threadReference, final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doKill(threadReference, stringTokenizer);
            }
        };
    }

    void commandKill(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Usage: kill <thread id> <throwable>");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
        if (threadInfo != null) {
            MessageOutput.println("killing thread:", threadInfo.getThread().name());
            this.doKillThread(threadInfo.getThread(), stringTokenizer);
            return;
        }
    }

    void listCaughtExceptions() {
        boolean bl = true;
        Iterator iterator = Env.specList.eventRequestSpecs().iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            if (!(eventRequestSpec instanceof ExceptionSpec)) continue;
            if (bl) {
                bl = false;
                MessageOutput.println("Exceptions caught:");
            }
            MessageOutput.println("tab", eventRequestSpec.toString());
        }
        if (bl) {
            MessageOutput.println("No exceptions caught.");
        }
    }

    private EventRequestSpec parseExceptionSpec(StringTokenizer stringTokenizer) {
        EventRequestSpec eventRequestSpec;
        block9: {
            String string = stringTokenizer.nextToken();
            boolean bl = false;
            boolean bl2 = false;
            eventRequestSpec = null;
            if (string.equals("uncaught")) {
                bl = false;
                bl2 = true;
            } else if (string.equals("caught")) {
                bl = true;
                bl2 = false;
            } else if (string.equals("all")) {
                bl = true;
                bl2 = true;
            } else {
                return null;
            }
            if (!stringTokenizer.hasMoreTokens()) break block9;
            String string2 = stringTokenizer.nextToken();
            if (bl || bl2) {
                try {
                    eventRequestSpec = Env.specList.createExceptionCatch(string2, bl, bl2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageOutput.println("is not a valid class name", string2);
                }
            }
        }
        return eventRequestSpec;
    }

    void commandCatchException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (eventRequestSpec != null) {
                this.resolveNow(eventRequestSpec);
            } else {
                MessageOutput.println("Usage: catch exception");
            }
        }
    }

    void commandIgnoreException(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec eventRequestSpec = this.parseExceptionSpec(stringTokenizer);
            if (Env.specList.delete(eventRequestSpec)) {
                MessageOutput.println("Removed:", eventRequestSpec.toString());
            } else {
                if (eventRequestSpec != null) {
                    MessageOutput.println("Not found:", eventRequestSpec.toString());
                }
                MessageOutput.println("Usage: ignore exception");
            }
        }
    }

    void commandUp(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int n2 = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string = stringTokenizer.nextToken();
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string);
                n3 = number.intValue();
            }
            catch (ParseException parseException) {
                n3 = 0;
            }
            if (n3 <= 0) {
                MessageOutput.println("Usage: up [n frames]");
                return;
            }
            n2 = n3;
        }
        try {
            threadInfo.up(n2);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageOutput.println("End of stack.");
        }
    }

    void commandDown(StringTokenizer stringTokenizer) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int n2 = 1;
        if (stringTokenizer.hasMoreTokens()) {
            int n3;
            String string = stringTokenizer.nextToken();
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string);
                n3 = number.intValue();
            }
            catch (ParseException parseException) {
                n3 = 0;
            }
            if (n3 <= 0) {
                MessageOutput.println("Usage: down [n frames]");
                return;
            }
            n2 = n3;
        }
        try {
            threadInfo.down(n2);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            MessageOutput.println("End of stack.");
        }
    }

    private void dumpStack(ThreadInfo threadInfo, boolean bl) {
        List list = null;
        try {
            list = threadInfo.getStack();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
            return;
        }
        if (list == null) {
            MessageOutput.println("Thread is not running (no stack).");
        } else {
            int n2 = list.size();
            int n3 = threadInfo.getCurrentFrameIndex();
            while (n3 < n2) {
                StackFrame stackFrame = (StackFrame)list.get(n3);
                this.dumpFrame(n3, bl, stackFrame);
                ++n3;
            }
        }
    }

    private void dumpFrame(int n2, boolean bl, StackFrame stackFrame) {
        Location location = stackFrame.location();
        long l2 = -1L;
        if (bl) {
            l2 = location.codeIndex();
        }
        Method method = location.method();
        long l3 = location.lineNumber();
        String string = null;
        if (method instanceof Method && method.isNative()) {
            string = MessageOutput.format("native method");
        } else if (l3 != -1L) {
            try {
                string = location.sourceName() + MessageOutput.format("line number", new Object[]{new Long(l3)});
            }
            catch (AbsentInformationException absentInformationException) {
                string = MessageOutput.format("unknown");
            }
        }
        if (l2 != -1L) {
            MessageOutput.println("stack frame dump with pc", new Object[]{new Integer(n2 + 1), method.declaringType().name(), method.name(), string, new Long(l2)});
        } else {
            MessageOutput.println("stack frame dump", new Object[]{new Integer(n2 + 1), method.declaringType().name(), method.name(), string});
        }
    }

    void commandWhere(StringTokenizer stringTokenizer, boolean bl) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            this.dumpStack(threadInfo, bl);
        } else {
            String string = stringTokenizer.nextToken();
            if (string.toLowerCase().equals("all")) {
                Iterator iterator = ThreadInfo.threads().iterator();
                while (iterator.hasNext()) {
                    ThreadInfo threadInfo = (ThreadInfo)iterator.next();
                    MessageOutput.println("Thread:", threadInfo.getThread().name());
                    this.dumpStack(threadInfo, bl);
                }
            } else {
                ThreadInfo threadInfo = this.doGetThread(string);
                if (threadInfo != null) {
                    ThreadInfo.setCurrentThreadInfo(threadInfo);
                    this.dumpStack(threadInfo, bl);
                }
            }
        }
    }

    void commandInterrupt(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            threadInfo.getThread().interrupt();
        } else {
            ThreadInfo threadInfo = this.doGetThread(stringTokenizer.nextToken());
            if (threadInfo != null) {
                threadInfo.getThread().interrupt();
            }
        }
    }

    void commandMemory() {
        MessageOutput.println("The memory command is no longer supported.");
    }

    void commandGC() {
        MessageOutput.println("The gc command is no longer necessary.");
    }

    static String locationString(Location location) {
        return MessageOutput.format("locationString", new Object[]{location.declaringType().name(), location.method().name(), new Integer(location.lineNumber()), new Long(location.codeIndex())});
    }

    void listBreakpoints() {
        boolean bl = true;
        Iterator iterator = Env.specList.eventRequestSpecs().iterator();
        while (iterator.hasNext()) {
            EventRequestSpec eventRequestSpec = (EventRequestSpec)iterator.next();
            if (!(eventRequestSpec instanceof BreakpointSpec)) continue;
            if (bl) {
                bl = false;
                MessageOutput.println("Breakpoints set:");
            }
            MessageOutput.println("tab", eventRequestSpec.toString());
        }
        if (bl) {
            MessageOutput.println("No breakpoints set.");
        }
    }

    private void printBreakpointCommandUsage(String string, String string2) {
        MessageOutput.println("printbreakpointcommandusage", new Object[]{string, string2});
    }

    protected BreakpointSpec parseBreakpointSpec(StringTokenizer stringTokenizer, String string, String string2) {
        EventRequestSpec eventRequestSpec = null;
        try {
            String string3;
            String string4 = stringTokenizer.nextToken(":( \t\n\r");
            try {
                string3 = stringTokenizer.nextToken("").trim();
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = null;
            }
            if (string3 != null && string3.startsWith(":")) {
                stringTokenizer = new StringTokenizer(string3.substring(1));
                String string5 = string4;
                String string6 = stringTokenizer.nextToken();
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setParseIntegerOnly(true);
                Number number = numberFormat.parse(string6);
                int n2 = number.intValue();
                if (stringTokenizer.hasMoreTokens()) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string5, n2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageOutput.println("is not a valid class name", string5);
                }
            } else {
                int n3 = string4.lastIndexOf(".");
                if (n3 <= 0 || n3 >= string4.length() - 1) {
                    this.printBreakpointCommandUsage(string, string2);
                    return null;
                }
                String string7 = string4.substring(n3 + 1);
                String string8 = string4.substring(0, n3);
                ArrayList<String> arrayList = null;
                if (string3 != null) {
                    if (!string3.startsWith("(") || !string3.endsWith(")")) {
                        MessageOutput.println("Invalid method specification:", string7 + string3);
                        this.printBreakpointCommandUsage(string, string2);
                        return null;
                    }
                    string3 = string3.substring(1, string3.length() - 1);
                    arrayList = new ArrayList<String>();
                    stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                }
                try {
                    eventRequestSpec = Env.specList.createBreakpoint(string8, string7, arrayList);
                }
                catch (MalformedMemberNameException malformedMemberNameException) {
                    MessageOutput.println("is not a valid method name", string7);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    MessageOutput.println("is not a valid class name", string8);
                }
            }
        }
        catch (Exception exception) {
            this.printBreakpointCommandUsage(string, string2);
            return null;
        }
        return (BreakpointSpec)eventRequestSpec;
    }

    private void resolveNow(EventRequestSpec eventRequestSpec) {
        boolean bl = Env.specList.addEagerlyResolve(eventRequestSpec);
        if (bl && !eventRequestSpec.isResolved()) {
            MessageOutput.println("Deferring.", eventRequestSpec.toString());
        }
    }

    void commandStop(StringTokenizer stringTokenizer) {
        String string;
        int n2 = 2;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("go") && stringTokenizer.hasMoreTokens()) {
                n2 = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread") && stringTokenizer.hasMoreTokens()) {
                n2 = 1;
                string = stringTokenizer.nextToken();
            }
        } else {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "stop at", "stop in");
        if (breakpointSpec != null) {
            if (string.equals("at") && breakpointSpec.isMethodBreakpoint()) {
                MessageOutput.println("Use stop at to set a breakpoint at a line number");
                this.printBreakpointCommandUsage("stop at", "stop in");
                return;
            }
            breakpointSpec.suspendPolicy = n2;
            this.resolveNow(breakpointSpec);
        }
    }

    void commandClear(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec breakpointSpec = this.parseBreakpointSpec(stringTokenizer, "clear", "clear");
        if (breakpointSpec != null) {
            if (Env.specList.delete(breakpointSpec)) {
                MessageOutput.println("Removed:", breakpointSpec.toString());
            } else {
                MessageOutput.println("Not found:", breakpointSpec.toString());
            }
        }
    }

    private List parseWatchpointSpec(StringTokenizer stringTokenizer) {
        ArrayList<EventRequestSpec> arrayList = new ArrayList<EventRequestSpec>();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 2;
        String string = stringTokenizer.nextToken();
        if (string.equals("go")) {
            n2 = 0;
            string = stringTokenizer.nextToken();
        } else if (string.equals("thread")) {
            n2 = 1;
            string = stringTokenizer.nextToken();
        }
        if (string.equals("access")) {
            bl = true;
            string = stringTokenizer.nextToken();
        } else if (string.equals("all")) {
            bl = true;
            bl2 = true;
            string = stringTokenizer.nextToken();
        } else {
            bl2 = true;
        }
        int n3 = string.lastIndexOf(46);
        if (n3 < 0) {
            MessageOutput.println("Class containing field must be specified.");
            return arrayList;
        }
        String string2 = string.substring(0, n3);
        string = string.substring(n3 + 1);
        try {
            EventRequestSpec eventRequestSpec;
            if (bl) {
                eventRequestSpec = Env.specList.createAccessWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n2;
                arrayList.add(eventRequestSpec);
            }
            if (bl2) {
                eventRequestSpec = Env.specList.createModificationWatchpoint(string2, string);
                eventRequestSpec.suspendPolicy = n2;
                arrayList.add(eventRequestSpec);
            }
        }
        catch (MalformedMemberNameException malformedMemberNameException) {
            MessageOutput.println("is not a valid field name", string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageOutput.println("is not a valid class name", string2);
        }
        return arrayList;
    }

    void commandWatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Field to watch not specified");
            return;
        }
        Iterator iterator = this.parseWatchpointSpec(stringTokenizer).iterator();
        while (iterator.hasNext()) {
            this.resolveNow((WatchpointSpec)iterator.next());
        }
    }

    void commandUnwatch(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Field to unwatch not specified");
            return;
        }
        Iterator iterator = this.parseWatchpointSpec(stringTokenizer).iterator();
        while (iterator.hasNext()) {
            WatchpointSpec watchpointSpec = (WatchpointSpec)iterator.next();
            if (Env.specList.delete(watchpointSpec)) {
                MessageOutput.println("Removed:", watchpointSpec.toString());
                continue;
            }
            MessageOutput.println("Not found:", watchpointSpec.toString());
        }
    }

    void commandTrace(StringTokenizer stringTokenizer) {
        int n2 = 2;
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("go")) {
                n2 = 0;
                string = stringTokenizer.nextToken();
            } else if (string.equals("thread")) {
                n2 = 1;
                string = stringTokenizer.nextToken();
            }
            if (!string.equals("methods")) {
                MessageOutput.println("Specify kind for example methods");
            }
        }
        ThreadInfo threadInfo = null;
        if (stringTokenizer.hasMoreTokens()) {
            threadInfo = this.doGetThread(stringTokenizer.nextToken());
        }
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        MethodEntryRequest methodEntryRequest = eventRequestManager.createMethodEntryRequest();
        MethodExitRequest methodExitRequest = eventRequestManager.createMethodExitRequest();
        if (threadInfo != null) {
            methodEntryRequest.addThreadFilter(threadInfo.getThread());
            methodExitRequest.addThreadFilter(threadInfo.getThread());
        }
        Env.addExcludes(methodEntryRequest);
        Env.addExcludes(methodExitRequest);
        methodEntryRequest.setSuspendPolicy(n2);
        methodExitRequest.setSuspendPolicy(n2);
        methodEntryRequest.enable();
        methodExitRequest.enable();
    }

    void commandUntrace(StringTokenizer stringTokenizer) {
        EventRequestManager eventRequestManager = Env.vm().eventRequestManager();
        Iterator iterator = eventRequestManager.methodEntryRequests().iterator();
        while (iterator.hasNext()) {
            ((EventRequest)iterator.next()).disable();
        }
        iterator = eventRequestManager.methodExitRequests().iterator();
        while (iterator.hasNext()) {
            ((EventRequest)iterator.next()).disable();
        }
    }

    void commandList(StringTokenizer stringTokenizer) {
        block20: {
            StackFrame stackFrame = null;
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            try {
                stackFrame = threadInfo.getCurrentFrame();
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                MessageOutput.println("Current thread isnt suspended.");
                return;
            }
            if (stackFrame == null) {
                MessageOutput.println("No frames on the current call stack");
                return;
            }
            Location location = stackFrame.location();
            if (location.method().isNative()) {
                MessageOutput.println("Current method is native");
                return;
            }
            String string = null;
            try {
                string = location.sourceName();
                ReferenceType referenceType = location.declaringType();
                int n2 = location.lineNumber();
                if (stringTokenizer.hasMoreTokens()) {
                    Object object;
                    String string2 = stringTokenizer.nextToken();
                    try {
                        NumberFormat numberFormat = NumberFormat.getNumberInstance();
                        numberFormat.setParseIntegerOnly(true);
                        object = numberFormat.parse(string2);
                        n2 = ((Number)object).intValue();
                    }
                    catch (ParseException parseException) {
                        object = referenceType.methodsByName(string2);
                        if (object == null || object.size() == 0) {
                            MessageOutput.println("is not a valid line number or method name for", new Object[]{string2, referenceType.name()});
                            return;
                        }
                        if (object.size() > 1) {
                            MessageOutput.println("is an ambiguous method name in", new Object[]{string2, referenceType.name()});
                            return;
                        }
                        location = ((Method)object.get(0)).location();
                        n2 = location.lineNumber();
                    }
                }
                int n3 = Math.max(n2 - 4, 1);
                int n4 = n3 + 9;
                if (n2 < 0) {
                    MessageOutput.println("Line number information not available for");
                    break block20;
                }
                if (Env.sourceLine(location, n2) == null) {
                    MessageOutput.println("is an invalid line number for", new Object[]{new Integer(n2), referenceType.name()});
                    break block20;
                }
                int n5 = n3;
                while (n5 <= n4) {
                    String string3 = Env.sourceLine(location, n5);
                    if (string3 != null) {
                        if (n5 == n2) {
                            MessageOutput.println("source line number current line and line", new Object[]{new Integer(n5), string3});
                        } else {
                            MessageOutput.println("source line number and line", new Object[]{new Integer(n5), string3});
                        }
                        ++n5;
                        continue;
                    }
                    break;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                MessageOutput.println("No source information available for:", location.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                MessageOutput.println("Source file not found:", string);
            }
            catch (IOException iOException) {
                MessageOutput.println("I/O exception occurred:", iOException.toString());
            }
        }
    }

    void commandLines(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Specify class and method");
        } else {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            try {
                ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
                if (referenceType != null) {
                    Object object;
                    Object object2;
                    List list = null;
                    if (string2 == null) {
                        list = referenceType.allLineLocations();
                    } else {
                        object2 = referenceType.allMethods();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            Method method = (Method)object.next();
                            if (!method.name().equals(string2)) continue;
                            list = method.allLineLocations();
                        }
                        if (list == null) {
                            MessageOutput.println("is not a valid method name", string2);
                        }
                    }
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (Location)object2.next();
                        MessageOutput.printDirectln(object.toString());
                    }
                } else {
                    MessageOutput.println("is not a valid id or class name", string);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                MessageOutput.println("Line number information not available for", string);
            }
        }
    }

    void commandClasspath(StringTokenizer stringTokenizer) {
        if (Env.vm() instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine pathSearchingVirtualMachine = (PathSearchingVirtualMachine)Env.vm();
            MessageOutput.println("base directory:", pathSearchingVirtualMachine.baseDirectory());
            MessageOutput.println("classpath:", pathSearchingVirtualMachine.classPath().toString());
            MessageOutput.println("bootclasspath:", pathSearchingVirtualMachine.bootClassPath().toString());
        } else {
            MessageOutput.println("The VM does not use paths");
        }
    }

    void commandUse(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.getSourcePath());
        } else {
            Env.setSourcePath(stringTokenizer.nextToken("").trim());
        }
    }

    private void printVar(LocalVariable localVariable, Value value) {
        MessageOutput.println("expr is value", new Object[]{localVariable.name(), value.toString()});
    }

    void commandLocals() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No default thread specified:");
            return;
        }
        try {
            Mirror mirror;
            Object object;
            StackFrame stackFrame = threadInfo.getCurrentFrame();
            if (stackFrame == null) {
                throw new AbsentInformationException();
            }
            List list = stackFrame.visibleVariables();
            if (list.size() == 0) {
                MessageOutput.println("No local variables");
                return;
            }
            Map map = stackFrame.getValues(list);
            MessageOutput.println("Method arguments:");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (LocalVariable)iterator.next();
                if (!object.isArgument()) continue;
                mirror = (Value)map.get(object);
                this.printVar((LocalVariable)object, (Value)mirror);
            }
            MessageOutput.println("Local variables:");
            object = list.iterator();
            while (object.hasNext()) {
                mirror = (LocalVariable)object.next();
                if (mirror.isArgument()) continue;
                Value value = (Value)map.get(mirror);
                this.printVar((LocalVariable)mirror, value);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            MessageOutput.println("Local variable information not available.");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Current thread isnt suspended.");
        }
    }

    private void dump(ObjectReference objectReference, ReferenceType referenceType, ReferenceType referenceType2) {
        Object object;
        Object object2;
        Iterator iterator = referenceType.fields().iterator();
        while (iterator.hasNext()) {
            object2 = new StringBuffer();
            object = (Field)iterator.next();
            ((StringBuffer)object2).append("    ");
            if (!referenceType.equals(referenceType2)) {
                ((StringBuffer)object2).append(referenceType.name());
                ((StringBuffer)object2).append(".");
            }
            ((StringBuffer)object2).append(object.name());
            ((StringBuffer)object2).append(MessageOutput.format("colon space"));
            ((StringBuffer)object2).append(objectReference.getValue((Field)object));
            MessageOutput.printDirectln(((StringBuffer)object2).toString());
        }
        if (referenceType instanceof ClassType) {
            object2 = ((ClassType)referenceType).superclass();
            if (object2 != null) {
                this.dump(objectReference, (ReferenceType)object2, referenceType2);
            }
        } else if (referenceType instanceof InterfaceType) {
            object2 = ((InterfaceType)referenceType).superinterfaces();
            object = object2.iterator();
            while (object.hasNext()) {
                this.dump(objectReference, (ReferenceType)object.next(), referenceType2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void doPrint(StringTokenizer var1_1, boolean var2_2) {
        if (var1_1.hasMoreTokens()) ** GOTO lbl17
        MessageOutput.println("No objects specified.");
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var1_1.nextToken("");
            var4_4 = this.evaluate(var3_3);
            if (var4_4 == null) {
                MessageOutput.println("expr is null", var3_3.toString());
                continue;
            }
            if (var2_2 && var4_4 instanceof ObjectReference && !(var4_4 instanceof StringReference)) {
                var5_5 = (ObjectReference)var4_4;
                var6_6 = var5_5.referenceType();
                MessageOutput.println("expr is value", new Object[]{var3_3.toString(), MessageOutput.format("grouping begin character")});
                this.dump(var5_5, var6_6, var6_6);
                MessageOutput.println("grouping end character");
                continue;
            }
            MessageOutput.println("expr is value", new Object[]{var3_3.toString(), var4_4.toString()});
lbl17:
            // 4 sources

            ** while (var1_1.hasMoreTokens())
        }
lbl18:
        // 1 sources

    }

    void commandPrint(final StringTokenizer stringTokenizer, final boolean bl) {
        new AsyncExecution(){

            void action() {
                Commands.this.doPrint(stringTokenizer, bl);
            }
        };
    }

    void commandSet(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken("");
        if (string.indexOf(61) == -1) {
            MessageOutput.println("Invalid assignment syntax");
            MessageOutput.printPrompt();
            return;
        }
        this.commandPrint(new StringTokenizer(string), false);
    }

    void doLock(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        try {
            if (value != null && value instanceof ObjectReference) {
                ObjectReference objectReference = (ObjectReference)value;
                MessageOutput.println("Monitor information for expr", new Object[]{string.trim(), value.toString()});
                ThreadReference threadReference = objectReference.owningThread();
                if (threadReference == null) {
                    MessageOutput.println("Not owned");
                } else {
                    MessageOutput.println("Owned by:", new Object[]{threadReference.name(), new Integer(objectReference.entryCount())});
                }
                List list = objectReference.waitingThreads();
                if (list.size() == 0) {
                    MessageOutput.println("No waiters");
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ThreadReference threadReference2 = (ThreadReference)iterator.next();
                        MessageOutput.println("Waiting thread:", threadReference.name());
                    }
                }
            } else {
                MessageOutput.println("Expression must evaluate to an object");
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("Threads must be suspended");
        }
    }

    void commandLock(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doLock(stringTokenizer);
            }
        };
    }

    private void printThreadLockInfo(ThreadInfo threadInfo) {
        block6: {
            ThreadReference threadReference = threadInfo.getThread();
            try {
                Object object;
                MessageOutput.println("Monitor information for thread", threadReference.name());
                List list = threadReference.ownedMonitors();
                if (list.size() == 0) {
                    MessageOutput.println("No monitors owned");
                } else {
                    object = list.iterator();
                    while (object.hasNext()) {
                        ObjectReference objectReference = (ObjectReference)object.next();
                        MessageOutput.println("Owned monitor:", objectReference.toString());
                    }
                }
                object = threadReference.currentContendedMonitor();
                if (object == null) {
                    MessageOutput.println("Not waiting for a monitor");
                    break block6;
                }
                MessageOutput.println("Waiting for monitor:", object.toString());
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                MessageOutput.println("Threads must be suspended");
            }
        }
    }

    void commandThreadlocks(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("Current thread not set.");
            } else {
                this.printThreadLockInfo(threadInfo);
            }
            return;
        }
        String string = stringTokenizer.nextToken();
        if (string.toLowerCase().equals("all")) {
            Iterator iterator = ThreadInfo.threads().iterator();
            while (iterator.hasNext()) {
                ThreadInfo threadInfo = (ThreadInfo)iterator.next();
                this.printThreadLockInfo(threadInfo);
            }
        } else {
            ThreadInfo threadInfo = this.doGetThread(string);
            if (threadInfo != null) {
                ThreadInfo.setCurrentThreadInfo(threadInfo);
                this.printThreadLockInfo(threadInfo);
            }
        }
    }

    void doDisableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.disableCollection();
            MessageOutput.println("GC Disabled for", value.toString());
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandDisableGC(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doDisableGC(stringTokenizer);
            }
        };
    }

    void doEnableGC(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String string = stringTokenizer.nextToken("");
        Value value = this.evaluate(string);
        if (value != null && value instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)value;
            objectReference.enableCollection();
            MessageOutput.println("GC Enabled for", value.toString());
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandEnableGC(final StringTokenizer stringTokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doEnableGC(stringTokenizer);
            }
        };
    }

    void doSave(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No save index specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No expression specified.");
            return;
        }
        String string2 = stringTokenizer.nextToken("");
        Value value = this.evaluate(string2);
        if (value != null) {
            Env.setSavedValue(string, value);
            MessageOutput.println("saved", value.toString());
        } else {
            MessageOutput.println("Expression cannot be void");
        }
    }

    /*
     * Unable to fully structure code
     */
    void commandSave(final StringTokenizer var1_1) {
        block4: {
            block3: {
                if (var1_1.hasMoreTokens()) break block3;
                var2_2 = Env.getSaveKeys();
                var3_3 = var2_2.iterator();
                if (var3_3.hasNext()) ** GOTO lbl16
                MessageOutput.println("No saved values");
                return;
lbl-1000:
                // 1 sources

                {
                    var4_4 = (String)var3_3.next();
                    var5_5 = Env.getSavedValue(var4_4);
                    if (var5_5 instanceof ObjectReference && ((ObjectReference)var5_5).isCollected()) {
                        MessageOutput.println("expr is value <collected>", new Object[]{var4_4, var5_5.toString()});
                        continue;
                    }
                    if (var5_5 == null) {
                        MessageOutput.println("expr is null", var4_4);
                        continue;
                    }
                    MessageOutput.println("expr is value", new Object[]{var4_4, var5_5.toString()});
lbl16:
                    // 4 sources

                    ** while (var3_3.hasNext())
                }
lbl17:
                // 1 sources

                break block4;
            }
            new AsyncExecution(){

                void action() {
                    Commands.this.doSave(var1_1);
                }
            };
        }
    }

    void commandBytecodes(StringTokenizer stringTokenizer) {
        Comparable comparable;
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No method specified.");
            return;
        }
        String string2 = stringTokenizer.nextToken();
        List list = Env.vm().classesByName(string);
        if (list.size() == 0) {
            if (string.indexOf(46) < 0) {
                MessageOutput.println("not found (try the full name)", string);
            } else {
                MessageOutput.println("not found", string);
            }
            return;
        }
        ReferenceType referenceType = (ReferenceType)list.get(0);
        if (!(referenceType instanceof ClassType)) {
            MessageOutput.println("not a class", string);
            return;
        }
        byte[] byArray = null;
        List list2 = referenceType.methodsByName(string2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            comparable = (Method)iterator.next();
            if (comparable.isAbstract()) continue;
            byArray = comparable.bytecodes();
            break;
        }
        comparable = new StringBuffer(80);
        ((StringBuffer)comparable).append("0000: ");
        int n2 = 0;
        while (n2 < byArray.length) {
            String string3;
            int n3;
            if (n2 > 0 && n2 % 16 == 0) {
                MessageOutput.printDirectln(((StringBuffer)comparable).toString());
                ((StringBuffer)comparable).setLength(0);
                ((StringBuffer)comparable).append(String.valueOf(n2));
                ((StringBuffer)comparable).append(": ");
                n3 = ((StringBuffer)comparable).length();
                int n4 = 0;
                while (n4 < 6 - n3) {
                    ((StringBuffer)comparable).insert(0, '0');
                    ++n4;
                }
            }
            if ((string3 = Integer.toHexString(n3 = 0xFF & byArray[n2])).length() == 1) {
                ((StringBuffer)comparable).append('0');
            }
            ((StringBuffer)comparable).append(string3);
            ((StringBuffer)comparable).append(' ');
            ++n2;
        }
        if (((StringBuffer)comparable).length() > 6) {
            MessageOutput.printDirectln(((StringBuffer)comparable).toString());
        }
    }

    void commandExclude(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.excludesString());
        } else {
            String string = stringTokenizer.nextToken("");
            if (string.equals("none")) {
                string = "";
            }
            Env.setExcludes(string);
        }
    }

    void commandRedefine(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("Specify classes to redefine");
        } else {
            Object object;
            String string = stringTokenizer.nextToken();
            List list = Env.vm().classesByName(string);
            if (list.size() == 0) {
                MessageOutput.println("No class named", string);
                return;
            }
            if (list.size() > 1) {
                MessageOutput.println("More than one class named", string);
                return;
            }
            ReferenceType referenceType = (ReferenceType)list.get(0);
            if (!stringTokenizer.hasMoreTokens()) {
                MessageOutput.println("Specify file name for class", string);
                return;
            }
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            byte[] byArray = new byte[(int)file.length()];
            try {
                object = new FileInputStream(file);
                ((InputStream)object).read(byArray);
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                MessageOutput.println("Error reading file", new Object[]{string2, exception.toString()});
                return;
            }
            object = new HashMap();
            object.put(referenceType, byArray);
            try {
                Env.vm().redefineClasses((Map)object);
            }
            catch (Throwable throwable) {
                MessageOutput.println("Error redefining class to file", new Object[]{string, string2, throwable});
            }
        }
    }

    void commandPopFrames(StringTokenizer stringTokenizer, boolean bl) {
        ThreadInfo threadInfo;
        Object object;
        if (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            threadInfo = this.doGetThread((String)object);
            if (threadInfo == null) {
                return;
            }
        } else {
            threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
        }
        try {
            object = threadInfo.getCurrentFrame();
            threadInfo.getThread().popFrames((StackFrame)object);
            if (bl) {
                this.commandStepi();
            }
        }
        catch (Throwable throwable) {
            MessageOutput.println("Error popping frame", throwable.toString());
        }
    }

    void commandExtension(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String string = stringTokenizer.nextToken();
        ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
        String string2 = null;
        if (referenceType != null) {
            try {
                string2 = referenceType.sourceDebugExtension();
                MessageOutput.println("sourcedebugextension", string2);
            }
            catch (AbsentInformationException absentInformationException) {
                MessageOutput.println("No sourcedebugextension specified");
            }
        } else {
            MessageOutput.println("is not a valid id or class name", string);
        }
    }

    void commandVersion(String string, long l2) {
        block2: {
            MessageOutput.println("minus version", new Object[]{string, new Date(l2)});
            if (Env.connection() == null) break block2;
            try {
                MessageOutput.printDirectln(Env.vm().description());
            }
            catch (VMNotConnectedException vMNotConnectedException) {
                MessageOutput.println("No VM connected");
            }
        }
    }

    abstract class AsyncExecution {
        abstract void action();

        AsyncExecution() {
            this.execute();
        }

        void execute() {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            int n2 = threadInfo == null ? 0 : threadInfo.getCurrentFrameIndex();
            Thread thread = new Thread(this, "asynchronous jdb command", threadInfo, n2){
                private final /* synthetic */ ThreadInfo val$threadInfo;
                private final /* synthetic */ int val$stackFrame;
                private final /* synthetic */ AsyncExecution this$1;
                {
                    this.this$1 = asyncExecution;
                    this.val$threadInfo = threadInfo;
                    this.val$stackFrame = n2;
                    super(string);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block23: {
                        block19: {
                            this.this$1.action();
                            if (this.val$threadInfo == null) break block19;
                            ThreadInfo.setCurrentThreadInfo(this.val$threadInfo);
                            try {
                                this.val$threadInfo.setCurrentFrameIndex(this.val$stackFrame);
                            }
                            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                MessageOutput.println("Current thread isnt suspended.");
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(this.val$stackFrame)});
                            }
                        }
                        MessageOutput.printPrompt();
                        break block23;
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            block20: {
                                MessageOutput.println("Operation is not supported on the target VM");
                                if (this.val$threadInfo == null) break block20;
                                ThreadInfo.setCurrentThreadInfo(this.val$threadInfo);
                                try {
                                    this.val$threadInfo.setCurrentFrameIndex(this.val$stackFrame);
                                }
                                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(this.val$stackFrame)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                        catch (Exception exception) {
                            block21: {
                                MessageOutput.println("Internal exception during operation:", exception.getMessage());
                                if (this.val$threadInfo == null) break block21;
                                {
                                    catch (Throwable throwable) {
                                        if (this.val$threadInfo != null) {
                                            ThreadInfo.setCurrentThreadInfo(this.val$threadInfo);
                                            try {
                                                this.val$threadInfo.setCurrentFrameIndex(this.val$stackFrame);
                                            }
                                            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                                MessageOutput.println("Current thread isnt suspended.");
                                            }
                                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(this.val$stackFrame)});
                                            }
                                        }
                                        MessageOutput.printPrompt();
                                        throw throwable;
                                    }
                                }
                                ThreadInfo.setCurrentThreadInfo(this.val$threadInfo);
                                try {
                                    this.val$threadInfo.setCurrentFrameIndex(this.val$stackFrame);
                                }
                                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(this.val$stackFrame)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                    }
                }
            };
            thread.start();
        }
    }
}

