/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.AbstractTreeWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import java.io.IOException;

public class TreeWriter
extends AbstractTreeWriter {
    private PackageDoc[] packages;
    private boolean classesonly;

    public TreeWriter(ConfigurationStandard configurationStandard, String string, ClassTree classTree) throws IOException {
        super(configurationStandard, string, classTree);
        this.packages = configurationStandard.packages;
        this.classesonly = this.packages.length == 0;
    }

    public static void generate(ConfigurationStandard configurationStandard, ClassTree classTree) {
        String string = "overview-tree.html";
        try {
            TreeWriter treeWriter = new TreeWriter(configurationStandard, string, classTree);
            treeWriter.generateTreeFile();
            treeWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateTreeFile() throws IOException {
        this.printHeader(this.getText("doclet.Window_Class_Hierarchy"));
        this.printTreeHeader();
        this.printPageHeading();
        this.printPackageTreeLinks();
        this.generateTree(this.classtree.baseclasses(), "doclet.Class_Hierarchy");
        this.generateTree(this.classtree.baseinterfaces(), "doclet.Interface_Hierarchy");
        this.printTreeFooter();
    }

    protected void printPackageTreeLinks() {
        if (this.packages.length == 1 && this.packages[0].name().length() == 0) {
            return;
        }
        if (!this.classesonly) {
            this.dl();
            this.dt();
            this.boldText("doclet.Package_Hierarchies");
            this.dd();
            int n2 = 0;
            while (n2 < this.packages.length) {
                if (this.packages[n2].name().length() != 0) {
                    String string = this.pathString(this.packages[n2], "package-tree.html");
                    this.printHyperLink(string, "", this.packages[n2].name());
                    if (n2 < this.packages.length - 1) {
                        this.print(", ");
                    }
                }
                ++n2;
            }
            this.dlEnd();
            this.hr();
        }
    }

    protected void printTreeHeader() {
        this.navLinks(true);
        this.hr();
    }

    protected void printTreeFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printPageHeading() {
        this.center();
        this.h2();
        this.printText("doclet.Hierarchy_For_All_Packages");
        this.h2End();
        this.centerEnd();
    }
}

