/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.FieldSubWriter;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.util.Arrays;
import java.util.List;

public class SerialFieldSubWriter
extends FieldSubWriter {
    ProgramElementDoc[] members = null;

    public SerialFieldSubWriter(SubWriterHolderWriter subWriterHolderWriter, ClassDoc classDoc) {
        super(subWriterHolderWriter, classDoc);
    }

    public List members(ClassDoc classDoc) {
        return Util.asList(classDoc.serializableFields());
    }

    void printSignature(MemberDoc memberDoc) {
        FieldDoc fieldDoc = (FieldDoc)memberDoc;
        this.printHead(memberDoc);
        this.writer.pre();
        this.printTypeLink(fieldDoc.type());
        this.print(' ');
        this.bold(fieldDoc.name());
        this.writer.preEnd();
    }

    protected void printTypeLinkNoDimension(Type type) {
        ClassDoc classDoc = type.asClassDoc();
        if (classDoc == null || classDoc.isPackagePrivate()) {
            this.print(type.typeName());
        } else {
            this.writer.printClassLink(classDoc);
        }
    }

    protected void printHeader(ClassDoc classDoc) {
        this.writer.anchor("serializedForm");
        this.printSerializableClassComment(classDoc);
        this.writer.printTableHeadingBackground(this.writer.getText("doclet.Serialized_Form_fields"));
    }

    private void printSerializableClassComment(ClassDoc classDoc) {
        FieldDoc fieldDoc;
        String string;
        if (classDoc.definesSerializableFields() && (string = (fieldDoc = (FieldDoc)this.members(this.classdoc).get(0)).commentText()).length() > 0) {
            this.writer.printTableHeadingBackground(this.writer.getText("doclet.Serialized_Form_class"));
            this.printFullComment(fieldDoc);
        }
    }

    protected void printBodyHtmlEnd(ClassDoc classDoc) {
    }

    protected void printMember(ProgramElementDoc programElementDoc) {
        FieldDoc fieldDoc = (FieldDoc)programElementDoc;
        ClassDoc classDoc = fieldDoc.containingClass();
        if (classDoc.definesSerializableFields()) {
            Object[] objectArray = fieldDoc.serialFieldTags();
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (n2 > 0) {
                    this.writer.printMemberHeader();
                }
                this.writer.h3();
                this.writer.print(objectArray[n2].fieldName());
                this.writer.h3End();
                this.printSignature((SerialFieldTag)objectArray[n2]);
                this.printComment((SerialFieldTag)objectArray[n2]);
                this.writer.printMemberFooter();
                ++n2;
            }
        } else {
            if (fieldDoc.tags("serial").length == 0 && !fieldDoc.isSynthetic()) {
                this.serialWarning(fieldDoc.position(), "doclet.MissingSerialTag", classDoc.qualifiedName(), fieldDoc.name());
            }
            this.printSignature(fieldDoc);
            this.printFullComment(fieldDoc);
        }
    }

    protected void printComment(ProgramElementDoc programElementDoc) {
        Tag[] tagArray;
        if (programElementDoc.inlineTags().length > 0) {
            this.writer.dd();
            this.writer.printInlineComment(programElementDoc);
        }
        if ((tagArray = programElementDoc.tags("serial")).length > 0) {
            this.writer.dt();
            this.writer.dd();
            this.writer.printInlineComment(programElementDoc, tagArray[0]);
        }
    }

    void printSignature(SerialFieldTag serialFieldTag) {
        this.writer.pre();
        ClassDoc classDoc = serialFieldTag.fieldTypeDoc();
        if (classDoc != null) {
            this.writer.printClassLink(classDoc);
        } else {
            this.writer.print(serialFieldTag.fieldType());
        }
        this.print(' ');
        this.bold(serialFieldTag.fieldName());
        this.writer.preEnd();
    }

    private void printComment(SerialFieldTag serialFieldTag) {
        this.writer.dl();
        this.writer.dd();
        this.writer.print(serialFieldTag.description());
        this.writer.dlEnd();
    }

    protected void printDeprecatedLink(ProgramElementDoc programElementDoc) {
    }

    public void printSummaryLabel(ClassDoc classDoc) {
    }

    public void printInheritedSummaryLabel(ClassDoc classDoc) {
    }

    protected void printSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
    }

    protected void printInheritedSummaryLink(ClassDoc classDoc, ProgramElementDoc programElementDoc) {
    }

    protected void printSummaryType(ProgramElementDoc programElementDoc) {
    }

    public void buildVisibleMemberMap() {
    }
}

