/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.Configuration;
import com.sun.tools.doclets.DirectoryManager;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.AbstractPackageWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import java.io.IOException;
import java.util.Arrays;

public class PackageFrameWriter
extends AbstractPackageWriter {
    public PackageFrameWriter(ConfigurationStandard configurationStandard, String string, String string2, PackageDoc packageDoc) throws IOException {
        super(configurationStandard, string, string2, packageDoc);
    }

    public static void generate(ConfigurationStandard configurationStandard, PackageDoc packageDoc) {
        String string = DirectoryManager.getDirectoryPath(packageDoc);
        String string2 = "package-frame.html";
        try {
            PackageFrameWriter packageFrameWriter = new PackageFrameWriter(configurationStandard, string, string2, packageDoc);
            packageFrameWriter.generatePackageFile();
            packageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        String string = this.packagedoc.name();
        Configuration configuration = this.configuration();
        if (this.packagedoc.isIncluded()) {
            this.generateClassKindListing(this.packagedoc.interfaces(), this.getText("doclet.Interfaces"));
            this.generateClassKindListing(this.packagedoc.ordinaryClasses(), this.getText("doclet.Classes"));
            this.generateClassKindListing(this.packagedoc.exceptions(), this.getText("doclet.Exceptions"));
            this.generateClassKindListing(this.packagedoc.errors(), this.getText("doclet.Errors"));
        } else {
            this.generateClassKindListing(configuration.classDocCatalog.interfaces(string), this.getText("doclet.Interfaces"));
            this.generateClassKindListing(configuration.classDocCatalog.ordinaryClasses(string), this.getText("doclet.Classes"));
            this.generateClassKindListing(configuration.classDocCatalog.exceptions(string), this.getText("doclet.Exceptions"));
            this.generateClassKindListing(configuration.classDocCatalog.errors(string), this.getText("doclet.Errors"));
        }
    }

    protected void generateClassKindListing(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            boolean bl = false;
            int n2 = 0;
            while (n2 < classDocArray.length) {
                if ((this.documentedClasses == null || this.documentedClasses.contains(classDocArray[n2])) && Util.isCoreClass(classDocArray[n2]) && this.isGeneratedDoc(classDocArray[n2])) {
                    if (!bl) {
                        this.print(string);
                        this.fontEnd();
                        this.println("&nbsp;");
                        this.fontStyle("FrameItemFont");
                        bl = true;
                    }
                    this.br();
                    this.printTargetClassLink(classDocArray[n2], "classFrame");
                }
                ++n2;
            }
            this.fontEnd();
            this.printPackageTableFooter();
            this.println();
        }
    }

    protected void printPackageHeader(String string) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packagedoc, "classFrame", string);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }

    protected void printPackageFooter() {
    }

    protected void printPackageDescription() throws IOException {
    }
}

