/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.ConstantFieldSubWriter;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ConstantsSummaryWriter
extends SubWriterHolderWriter {
    ConfigurationStandard configuration;
    private Set classDocsWithConstFields;
    private Set printedPackageHeaders;
    private String UNNAMED_PACKAGE_ANCHOR = "unnamed_package";
    private String UNNAMED_PACKAGE_HEADING = "Unnamed Package";

    public ConstantsSummaryWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.configuration = configurationStandard;
        this.classDocsWithConstFields = new HashSet();
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "constant-values.html";
        try {
            ConstantsSummaryWriter constantsSummaryWriter = new ConstantsSummaryWriter(configurationStandard, string);
            constantsSummaryWriter.generateConstantsFile(configurationStandard.root);
            constantsSummaryWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    public void generateConstantsFile(RootDoc rootDoc) {
        this.printHeader(this.getText("doclet.Constants_Summary"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Constants_Summary");
        this.h1End();
        this.centerEnd();
        this.hr(4, "noshade");
        this.generateIndex(rootDoc);
        this.generateContents(rootDoc);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void generateIndex(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        this.bold(this.getText("doclet.Contents"));
        this.ul();
        int n2 = 0;
        while (n2 < packageDocArray.length) {
            String string = packageDocArray[n2].name();
            if (this.hasConstantField(packageDocArray[n2]) && !this.hasPrintedPackage(string)) {
                this.li();
                if (string.length() == 0) {
                    this.printHyperLink("#" + this.UNNAMED_PACKAGE_ANCHOR, this.UNNAMED_PACKAGE_HEADING);
                } else {
                    string = this.parsePackageName(string);
                    this.printHyperLink("#" + string, string + ".*");
                    this.printedPackageHeaders.add(string);
                }
                this.print("\n");
            }
            ++n2;
        }
        this.ulEnd();
        this.print("\n");
    }

    protected void generateContents(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        boolean bl = true;
        int n2 = 0;
        while (n2 < packageDocArray.length) {
            Object[] objectArray = packageDocArray[n2].name().length() > 0 ? packageDocArray[n2].allClasses() : this.configuration.classDocCatalog.allClasses("");
            boolean bl2 = true;
            Arrays.sort(objectArray);
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object = objectArray[n3];
                if (this.classDocsWithConstFields.contains(object) && object.isIncluded()) {
                    if (bl2) {
                        this.printPackageName(packageDocArray[n2].name());
                        bl2 = false;
                    }
                    bl = false;
                    this.printConstantMemberInfo((ClassDoc)object);
                }
                ++n3;
            }
            ++n2;
        }
    }

    private boolean hasConstantField(PackageDoc packageDoc) {
        ClassDoc[] classDocArray = packageDoc.name().length() > 0 ? packageDoc.allClasses() : this.configuration.classDocCatalog.allClasses("");
        boolean bl = false;
        int n2 = 0;
        while (n2 < classDocArray.length) {
            if (classDocArray[n2].isIncluded() && this.hasConstantField(classDocArray[n2])) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        FieldDoc[] fieldDocArray = classDoc.fields();
        int n2 = 0;
        while (n2 < fieldDocArray.length) {
            if (fieldDocArray[n2].constantValueExpression() != null) {
                this.classDocsWithConstFields.add(classDoc);
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void printConstantMemberInfo(ClassDoc classDoc) {
        String string = classDoc.isPublic() || classDoc.isProtected() ? this.getClassLink(classDoc) : classDoc.qualifiedName();
        String string2 = classDoc.containingPackage().name();
        if (string2.length() > 0) {
            this.printClassName(string2 + "." + string);
        } else {
            this.printClassName(string);
        }
        this.printConstantMembers(classDoc);
        this.tableFooter();
        this.p();
    }

    protected void printConstantMembers(ClassDoc classDoc) {
        new ConstantFieldSubWriter(this, classDoc).printMembersSummary();
    }

    protected void printPackageName(String string) {
        if (string.length() == 0) {
            this.anchor(this.UNNAMED_PACKAGE_ANCHOR);
            string = this.UNNAMED_PACKAGE_HEADING;
        } else {
            if (this.hasPrintedPackage(string)) {
                return;
            }
            string = this.parsePackageName(string);
            this.anchor(string);
        }
        this.packageTableHeader();
        this.tdAlign("left");
        this.font("+2");
        this.printedPackageHeaders.add(string);
        this.bold(string + ".*");
        this.tableFooter();
    }

    private String parsePackageName(String string) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < 2) {
            n2 = string.indexOf(".", n2 + 1);
            ++n3;
        }
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    protected boolean hasPrintedPackage(String string) {
        String[] stringArray = this.printedPackageHeaders.toArray(new String[0]);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string.startsWith(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void printClassName(String string) {
        this.classTableHeader();
        this.tdColspan(3);
        this.bold(string);
        this.tdEnd();
        this.trEnd();
    }

    private void packageTableHeader() {
        this.println("\n<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        this.trBgcolorStyle("#CCCCFF", "TableHeadingColor");
    }

    private void classTableHeader() {
        this.println("\n<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\">");
        this.trBgcolorStyle("#EEEEFF", "TableSubHeadingColor");
    }

    private void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }
}

