/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VisibleMemberMap {
    public static final int INNERCLASSES = 0;
    public static final int FIELDS = 1;
    public static final int CONSTRUCTORS = 2;
    public static final int METHODS = 3;
    public static final String STARTLEVEL = "start";
    private final List visibleClasses = new ArrayList();
    private final Map memberNameMap = new HashMap();
    private final Map classMap = new HashMap();
    private final ClassDoc classdoc;
    private final int kind;
    private final boolean nodepr;

    public VisibleMemberMap(ClassDoc classDoc, int n2, boolean bl) {
        this.classdoc = classDoc;
        this.nodepr = bl;
        this.kind = n2;
        new ClassMembers(classDoc, STARTLEVEL).build();
    }

    public List getVisibleClassesList() {
        this.sort(this.visibleClasses);
        return this.visibleClasses;
    }

    public List getMembersFor(ClassDoc classDoc) {
        ClassMembers classMembers = (ClassMembers)this.classMap.get(classDoc);
        if (classMembers == null) {
            return new ArrayList();
        }
        return classMembers.getMembers();
    }

    private void sort(List list) {
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        ArrayList<ClassDoc> arrayList2 = new ArrayList<ClassDoc>();
        int n2 = 0;
        while (n2 < list.size()) {
            ClassDoc classDoc = (ClassDoc)list.get(n2);
            if (classDoc.isClass()) {
                arrayList.add(classDoc);
            } else {
                arrayList2.add(classDoc);
            }
            ++n2;
        }
        list.clear();
        list.addAll(arrayList);
        list.addAll(arrayList2);
    }

    private void fillMemberLevelMap(List list, String string) {
        int n2 = 0;
        while (n2 < list.size()) {
            ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(n2);
            String string2 = VisibleMemberMap.getDocName(programElementDoc);
            HashMap<ProgramElementDoc, String> hashMap = (HashMap<ProgramElementDoc, String>)this.memberNameMap.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap<ProgramElementDoc, String>();
                this.memberNameMap.put(string2, hashMap);
            }
            hashMap.put(programElementDoc, string);
            ++n2;
        }
    }

    protected static String getDocName(ProgramElementDoc programElementDoc) {
        if (programElementDoc.isMethod() || programElementDoc.isConstructor()) {
            return programElementDoc.name() + ((ExecutableMemberDoc)programElementDoc).signature();
        }
        if (programElementDoc.isField()) {
            return programElementDoc.name();
        }
        return "clint" + programElementDoc.name();
    }

    private class ClassMembers {
        private ClassDoc mappingClass;
        private List members = new ArrayList();
        private String level;

        public List getMembers() {
            return this.members;
        }

        private ClassMembers(ClassDoc classDoc, String string) {
            this.mappingClass = classDoc;
            this.level = string;
            if (!VisibleMemberMap.this.classMap.containsKey(classDoc)) {
                VisibleMemberMap.this.classMap.put(classDoc, this);
                VisibleMemberMap.this.visibleClasses.add(classDoc);
            }
        }

        private void build() {
            if (VisibleMemberMap.this.kind == 2) {
                this.addMembers(this.mappingClass);
            } else {
                this.mapClass(this);
            }
        }

        private void mapClass(ClassMembers classMembers) {
            ClassMembers classMembers2;
            Object object;
            if (this.checkAccess(this.mappingClass)) {
                classMembers = this;
            }
            classMembers.addMembers(this.mappingClass);
            ClassDoc[] classDocArray = this.mappingClass.interfaces();
            int n2 = 0;
            while (n2 < classDocArray.length) {
                object = this.level + (n2 + 1);
                classMembers2 = new ClassMembers(classDocArray[n2], (String)object);
                classMembers2.mapClass(classMembers);
                ++n2;
            }
            if (this.mappingClass.isClass() && (object = this.mappingClass.superclass()) != null) {
                classMembers2 = new ClassMembers((ClassDoc)object, this.level + "c");
                classMembers2.mapClass(classMembers);
            }
        }

        private boolean checkAccess(ClassDoc classDoc) {
            return classDoc.isPublic() || classDoc.isProtected() || classDoc.isPrivate() && classDoc.isPackagePrivate();
        }

        private void addMembers(ClassDoc classDoc) {
            List list = this.getClassMembers(classDoc);
            ArrayList<ProgramElementDoc> arrayList = new ArrayList<ProgramElementDoc>();
            int n2 = 0;
            while (n2 < list.size()) {
                ProgramElementDoc programElementDoc = (ProgramElementDoc)list.get(n2);
                if (!this.found(this.members, programElementDoc) && this.isVisible(programElementDoc) && !this.isOverridden(programElementDoc, this.level)) {
                    arrayList.add(programElementDoc);
                }
                ++n2;
            }
            this.members.addAll(arrayList);
            VisibleMemberMap.this.fillMemberLevelMap(this.members, this.level);
        }

        private boolean isVisible(ProgramElementDoc programElementDoc) {
            if (programElementDoc.containingClass() == this.mappingClass) {
                return true;
            }
            if (programElementDoc.isPrivate()) {
                return false;
            }
            if (programElementDoc.isPackagePrivate()) {
                return programElementDoc.containingClass().containingPackage() == this.mappingClass.containingPackage();
            }
            return true;
        }

        private List getClassMembers(ClassDoc classDoc) {
            ProgramElementDoc[] programElementDocArray = null;
            switch (VisibleMemberMap.this.kind) {
                case 0: {
                    programElementDocArray = classDoc.innerClasses();
                    break;
                }
                case 1: {
                    programElementDocArray = classDoc.fields();
                    break;
                }
                case 2: {
                    programElementDocArray = classDoc.constructors();
                    break;
                }
                case 3: {
                    programElementDocArray = classDoc.methods();
                    break;
                }
                default: {
                    programElementDocArray = new ProgramElementDoc[]{};
                }
            }
            if (VisibleMemberMap.this.nodepr) {
                return Util.excludeDeprecatedMembersAsList(programElementDocArray);
            }
            return Util.asList(programElementDocArray);
        }

        private boolean found(List list, ProgramElementDoc programElementDoc) {
            int n2 = 0;
            while (n2 < list.size()) {
                ProgramElementDoc programElementDoc2 = (ProgramElementDoc)list.get(n2);
                if (Util.matches(programElementDoc2, programElementDoc)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isOverridden(ProgramElementDoc programElementDoc, String string) {
            Map map = (Map)VisibleMemberMap.this.memberNameMap.get(VisibleMemberMap.getDocName(programElementDoc));
            if (map == null) {
                return false;
            }
            String string2 = null;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string2.equals(VisibleMemberMap.STARTLEVEL) && !string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

