/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndexBuilder {
    private Map indexmap = new HashMap();
    private boolean noDeprecated;
    private boolean classesOnly;
    protected final Object[] elements;

    public IndexBuilder(Configuration configuration, boolean bl) {
        this(configuration, bl, false);
    }

    public IndexBuilder(Configuration configuration, boolean bl, boolean bl2) {
        if (bl2) {
            configuration.message.notice("doclet.Building_Index_For_All_Classes");
        } else {
            configuration.message.notice("doclet.Building_Index");
        }
        this.noDeprecated = bl;
        this.classesOnly = bl2;
        this.buildIndexMap(configuration.root);
        Set set = this.indexmap.keySet();
        this.elements = set.toArray();
        Arrays.sort(this.elements);
    }

    protected void sortIndexMap() {
        Iterator iterator = this.indexmap.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next());
        }
    }

    protected void buildIndexMap(RootDoc rootDoc) {
        Doc[] docArray = rootDoc.specifiedPackages();
        Doc[] docArray2 = rootDoc.classes();
        ArrayList arrayList = new ArrayList();
        if (!this.classesOnly) {
            if (docArray.length == 0) {
                HashSet<PackageDoc> hashSet = new HashSet<PackageDoc>();
                int n2 = 0;
                while (n2 < docArray2.length) {
                    PackageDoc packageDoc = docArray2[n2].containingPackage();
                    if (packageDoc != null && packageDoc.name().length() > 0) {
                        hashSet.add(packageDoc);
                    }
                    ++n2;
                }
                this.adjustIndexMap((PackageDoc[])hashSet.toArray(docArray));
            } else {
                this.adjustIndexMap(docArray);
            }
        }
        this.adjustIndexMap(docArray2);
        if (!this.classesOnly) {
            int n3 = 0;
            while (n3 < docArray2.length) {
                if (this.shouldAddToIndexMap(docArray2[n3])) {
                    this.putMembersInIndexMap((ClassDoc)docArray2[n3]);
                }
                ++n3;
            }
        }
        this.sortIndexMap();
    }

    protected void putMembersInIndexMap(ClassDoc classDoc) {
        this.adjustIndexMap(classDoc.fields());
        this.adjustIndexMap(classDoc.methods());
        this.adjustIndexMap(classDoc.constructors());
    }

    protected void adjustIndexMap(Doc[] docArray) {
        int n2 = 0;
        while (n2 < docArray.length) {
            if (this.shouldAddToIndexMap(docArray[n2])) {
                String string = docArray[n2].name();
                char c2 = string.length() == 0 ? (char)'*' : (char)Character.toUpperCase(string.charAt(0));
                Character c3 = new Character(c2);
                ArrayList<Doc> arrayList = (ArrayList<Doc>)this.indexmap.get(c3);
                if (arrayList == null) {
                    arrayList = new ArrayList<Doc>();
                    this.indexmap.put(c3, arrayList);
                }
                arrayList.add(docArray[n2]);
            }
            ++n2;
        }
    }

    protected boolean shouldAddToIndexMap(Doc doc) {
        return !this.noDeprecated || doc.tags("deprecated").length <= 0;
    }

    public Map getIndexMap() {
        return this.indexmap;
    }

    public List getMemberList(Character c2) {
        return (List)this.indexmap.get(c2);
    }

    public Object[] elements() {
        return this.elements;
    }
}

