/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.Util;
import java.util.ArrayList;
import java.util.List;

public class ImplementedMethods {
    private List methlist = new ArrayList();
    private final ClassDoc classdoc;
    private final MethodDoc method;

    public ImplementedMethods(MethodDoc methodDoc) {
        this.method = methodDoc;
        this.classdoc = methodDoc.containingClass();
    }

    public MethodDoc[] build() {
        ClassDoc classDoc = this.classdoc;
        while (classDoc != null) {
            this.buildImplementedMethodList(classDoc.interfaces());
            classDoc = classDoc.superclass();
        }
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    private void buildImplementedMethodList(ClassDoc[] classDocArray) {
        int n2 = 0;
        while (n2 < classDocArray.length) {
            MethodDoc methodDoc = Util.findMethod(classDocArray[n2], this.method);
            if (methodDoc != null) {
                this.removeOverriddenMethod(methodDoc);
                if (!this.overridingMethodFound(methodDoc)) {
                    this.methlist.add(methodDoc);
                }
            }
            ClassDoc[] classDocArray2 = classDocArray[n2].interfaces();
            this.buildImplementedMethodList(classDocArray2);
            ++n2;
        }
    }

    private void removeOverriddenMethod(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDoc != null) {
            int n2 = 0;
            while (n2 < this.methlist.size()) {
                ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(n2)).containingClass();
                if (classDoc2 == classDoc || classDoc.subclassOf(classDoc2)) {
                    this.methlist.remove(n2);
                    return;
                }
                ++n2;
            }
        }
    }

    private boolean overridingMethodFound(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.containingClass();
        int n2 = 0;
        while (n2 < this.methlist.size()) {
            MethodDoc methodDoc2 = (MethodDoc)this.methlist.get(n2);
            if (classDoc == methodDoc2.containingClass()) {
                return true;
            }
            ClassDoc classDoc2 = methodDoc2.overriddenClass();
            if (classDoc2 != null && (classDoc2 == classDoc || classDoc2.subclassOf(classDoc))) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

