/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ValueGen
implements com.sun.tools.corba.se.idl.ValueGen,
JavaGenerator {
    protected int emit = 0;
    protected Factories factories = null;
    protected Hashtable symbolTable = null;
    protected ValueEntry v = null;
    protected PrintWriter stream = null;
    protected boolean explicitDefaultInit = false;

    public void generate(Hashtable hashtable, ValueEntry valueEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.v = valueEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateTie();
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.emit = ((Arguments)Compile.compiler.arguments).emit;
        this.factories = (Factories)Compile.compiler.factories();
    }

    protected void openStream() {
        this.stream = Util.stream(this.v, ".java");
    }

    protected void generateTie() {
        boolean bl = ((Arguments)Compile.compiler.arguments).TIEServer;
        if (this.v.supports().size() > 0 && bl) {
            Factories factories = (Factories)Compile.compiler.factories();
            factories.skeleton().generate(this.symbolTable, this.v);
        }
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.v);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.v);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.v);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.v.comment() != null) {
            this.v.comment().generate("", this.stream);
        }
        if (this.v.isAbstract()) {
            this.writeAbstract();
            return;
        }
        this.stream.print("public class " + this.v.name());
        SymtabEntry symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(0);
        String string = Util.javaName(symtabEntry);
        boolean bl = false;
        if (string.equals("java.io.Serializable")) {
            this.stream.print(" implements org.omg.CORBA.portable.ValueBase");
            bl = true;
        } else if (!((ValueEntry)symtabEntry).isAbstract()) {
            this.stream.print(" extends " + string);
        }
        int n2 = 0;
        while (n2 < this.v.derivedFrom().size()) {
            symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(n2);
            if (((ValueEntry)symtabEntry).isAbstract()) {
                if (!bl) {
                    this.stream.print(" implements ");
                    bl = true;
                } else {
                    this.stream.print(", ");
                }
                this.stream.print(Util.javaName(symtabEntry));
            }
            ++n2;
        }
        if (this.v.supports().size() > 0) {
            if (!bl) {
                this.stream.print(" implements ");
                bl = true;
            } else {
                this.stream.print(", ");
            }
            InterfaceEntry interfaceEntry = (InterfaceEntry)this.v.supports().elementAt(0);
            if (interfaceEntry.isAbstract()) {
                this.stream.print(Util.javaName(interfaceEntry));
            } else {
                this.stream.print(Util.javaName(interfaceEntry) + "Operations");
            }
        }
        if (this.v.isCustom()) {
            if (!bl) {
                this.stream.print(" implements ");
                bl = true;
            } else {
                this.stream.print(", ");
            }
            this.stream.print("org.omg.CORBA.CustomMarshal ");
        }
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeInitializers();
        this.writeConstructor();
        this.writeTruncatable();
        this.writeMethods();
    }

    protected void writeClosing() {
        if (this.v.isAbstract()) {
            this.stream.println("} // interface " + this.v.name());
        } else {
            this.stream.println("} // class " + this.v.name());
        }
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeConstructor() {
        if (!this.v.isAbstract() && !this.explicitDefaultInit) {
            this.stream.println("  protected " + this.v.name() + " () {}");
            this.stream.println();
        }
    }

    protected void writeTruncatable() {
        if (!this.v.isAbstract()) {
            this.stream.println("  public String[] _truncatable_ids() {");
            this.stream.println("      return " + Util.helperName(this.v, true) + ".get_instance().get_truncatable_base_ids();");
            this.stream.println("  }");
            this.stream.println();
        }
    }

    protected void writeMembers() {
        if (this.v.state() == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.v.state().size()) {
            InterfaceState interfaceState = (InterfaceState)this.v.state().elementAt(n2);
            TypedefEntry typedefEntry = interfaceState.entry;
            Util.fillInfo(typedefEntry);
            if (typedefEntry.comment() != null) {
                typedefEntry.comment().generate(" ", this.stream);
            }
            String string = "  ";
            if (interfaceState.modifier == 2) {
                string = "  public ";
            }
            Util.writeInitializer(string, typedefEntry.name(), "", typedefEntry, this.stream);
            ++n2;
        }
    }

    protected void writeInitializers() {
        Vector vector = this.v.initializers();
        if (vector != null) {
            this.stream.println();
            int n2 = 0;
            while (n2 < vector.size()) {
                MethodEntry methodEntry = (MethodEntry)vector.elementAt(n2);
                methodEntry.valueMethod(true);
                ((MethodGen)methodEntry.generator()).interfaceMethod(this.symbolTable, methodEntry, this.stream);
                if (methodEntry.parameters().isEmpty()) {
                    this.explicitDefaultInit = true;
                }
                ++n2;
            }
        }
    }

    protected void writeMethods() {
        MethodEntry methodEntry;
        Object object;
        Object object2;
        SymtabEntry symtabEntry;
        Enumeration enumeration = this.v.contained().elements();
        while (enumeration.hasMoreElements()) {
            symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof MethodEntry) {
                object2 = (MethodEntry)symtabEntry;
                ((MethodGen)((MethodEntry)object2).generator()).interfaceMethod(this.symbolTable, (MethodEntry)object2, this.stream);
                continue;
            }
            if (symtabEntry instanceof TypedefEntry) {
                symtabEntry.type().generate(this.symbolTable, this.stream);
            }
            symtabEntry.generate(this.symbolTable, this.stream);
        }
        if (this.v.isAbstract()) {
            return;
        }
        if (this.v.supports().size() > 0) {
            symtabEntry = (InterfaceEntry)this.v.supports().elementAt(0);
            object2 = ((InterfaceEntry)symtabEntry).allMethods().elements();
            while (object2.hasMoreElements()) {
                object = (MethodEntry)object2.nextElement();
                methodEntry = (MethodEntry)((MethodEntry)object).clone();
                methodEntry.container(this.v);
                ((MethodGen)methodEntry.generator()).interfaceMethod(this.symbolTable, methodEntry, this.stream);
            }
        }
        int n2 = 0;
        while (n2 < this.v.derivedFrom().size()) {
            object2 = (ValueEntry)this.v.derivedFrom().elementAt(n2);
            if (((InterfaceEntry)object2).isAbstract()) {
                object = ((InterfaceEntry)object2).allMethods().elements();
                while (object.hasMoreElements()) {
                    methodEntry = (MethodEntry)object.nextElement();
                    MethodEntry methodEntry2 = (MethodEntry)methodEntry.clone();
                    methodEntry2.container(this.v);
                    ((MethodGen)methodEntry2.generator()).interfaceMethod(this.symbolTable, methodEntry2, this.stream);
                }
            }
            ++n2;
        }
    }

    protected void writeStreamableMethods() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream istream)");
        this.stream.println("  {");
        this.read(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream ostream)");
        this.stream.println("  {");
        this.write(0, "    ", "this", this.v, this.stream);
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + Util.helperName(this.v, false) + ".type ();");
        this.stream.println("  }");
    }

    public int helperType(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        ValueEntry valueEntry = (ValueEntry)symtabEntry;
        Vector vector = valueEntry.state();
        int n3 = vector == null ? 0 : vector.size();
        String string3 = "_members" + n2++;
        String string4 = "_tcOf" + string3;
        printWriter.println(string + "org.omg.CORBA.ValueMember[] " + string3 + " = new org.omg.CORBA.ValueMember[" + n3 + "];");
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string4 + " = null;");
        String string5 = "_id";
        int n4 = 0;
        while (n4 < n3) {
            String string6;
            String string7;
            InterfaceState interfaceState = (InterfaceState)vector.elementAt(n4);
            TypedefEntry typedefEntry = interfaceState.entry;
            SymtabEntry symtabEntry2 = Util.typeOf(typedefEntry);
            if (ValueGen.hasRepId(typedefEntry)) {
                string7 = Util.helperName(symtabEntry2, true) + ".id ()";
                if (symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) {
                    string6 = "\"\"";
                } else {
                    String string8 = symtabEntry2.repositoryID().ID();
                    string6 = '\"' + string8.substring(string8.lastIndexOf(58) + 1) + '\"';
                }
            } else {
                string7 = "\"\"";
                string6 = "\"\"";
            }
            printWriter.println(string + "// ValueMember instance for " + typedefEntry.name());
            n2 = ((JavaGenerator)((Object)typedefEntry.generator())).type(n2, string, tCOffsets, string4, typedefEntry, printWriter);
            printWriter.println(string + string3 + "[" + n4 + "] = new org.omg.CORBA.ValueMember (" + '\"' + typedefEntry.name() + "\", ");
            printWriter.println(string + "    " + string7 + ", ");
            printWriter.println(string + "    " + string5 + ", ");
            printWriter.println(string + "    " + string6 + ", ");
            printWriter.println(string + "    " + string4 + ", ");
            printWriter.println(string + "    " + "null, ");
            printWriter.println(string + "    " + "org.omg.CORBA." + (interfaceState.modifier == 2 ? "PUBLIC_MEMBER" : "PRIVATE_MEMBER") + ".value" + ");");
            ++n4;
        }
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_value_tc (" + "_id, " + '\"' + symtabEntry.name() + "\", " + ValueGen.getValueModifier(valueEntry) + ", " + ValueGen.getConcreteBaseTypeCode(valueEntry) + ", " + string3 + ");");
        return n2;
    }

    public int type(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n2;
    }

    private static boolean hasRepId(SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = Util.typeOf(symtabEntry);
        return !(symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry && !((TypedefEntry)symtabEntry2).arrayInfo().isEmpty() || symtabEntry2 instanceof TypedefEntry && symtabEntry.type() instanceof SequenceEntry);
    }

    private static String getValueModifier(ValueEntry valueEntry) {
        String string = "NONE";
        if (valueEntry.isCustom()) {
            string = "CUSTOM";
        } else if (valueEntry.isAbstract()) {
            string = "ABSTRACT";
        } else if (valueEntry.isSafe()) {
            string = "TRUNCATABLE";
        }
        return "org.omg.CORBA.VM_" + string + ".value";
    }

    private static String getConcreteBaseTypeCode(ValueEntry valueEntry) {
        SymtabEntry symtabEntry;
        Vector vector = valueEntry.derivedFrom();
        if (!valueEntry.isAbstract() && !"ValueBase".equals((symtabEntry = (SymtabEntry)valueEntry.derivedFrom().elementAt(0)).name())) {
            return Util.helperName(symtabEntry, true) + ".type ()";
        }
        return "null";
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (((ValueEntry)symtabEntry).isAbstract()) {
            printWriter.println("    throw new org.omg.CORBA.BAD_OPERATION (\"abstract value cannot be instantiated\");");
        } else {
            printWriter.println("    return (" + string + ") ((org.omg.CORBA_2_3.portable.InputStream) istream).read_value (get_instance());");
        }
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public java.io.Serializable read_value (org.omg.CORBA.portable.InputStream istream)");
        printWriter.println("  {");
        if (((ValueEntry)symtabEntry).isAbstract()) {
            printWriter.println("    throw new org.omg.CORBA.BAD_OPERATION (\"abstract value cannot be instantiated\");");
        } else if (((ValueEntry)symtabEntry).isCustom()) {
            printWriter.println("    throw new org.omg.CORBA.BAD_OPERATION (\"custom values should use unmarshal()\");");
        } else {
            printWriter.println("    " + string + " value = new " + string + " ();");
            this.read(0, "    ", "value", symtabEntry, printWriter);
            printWriter.println("    return value;");
        }
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public static void read (org.omg.CORBA.portable.InputStream istream, " + string + " value)");
        printWriter.println("  {");
        this.read(0, "    ", "value", symtabEntry, printWriter);
    }

    public int read(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Object object;
        Vector vector = ((ValueEntry)symtabEntry).derivedFrom();
        if (vector != null && vector.size() != 0) {
            object = (ValueEntry)vector.elementAt(0);
            if (object == null) {
                return n2;
            }
            if (!Util.javaQualifiedName((SymtabEntry)object).equals("java.io.Serializable")) {
                printWriter.println(string + Util.helperName((SymtabEntry)object, true) + ".read (istream, value);");
            }
        }
        int n3 = (object = ((ValueEntry)symtabEntry).state()) == null ? 0 : ((Vector)object).size();
        int n4 = 0;
        while (n4 < n3) {
            TypedefEntry typedefEntry = ((InterfaceState)((Vector)object).elementAt((int)n4)).entry;
            String string3 = typedefEntry.name();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
                n2 = ((JavaGenerator)((Object)typedefEntry.generator())).read(n2, string, string2 + '.' + string3, typedefEntry, printWriter);
            } else if (symtabEntry2 instanceof ValueEntry) {
                String string4 = Util.javaQualifiedName(symtabEntry2);
                if (symtabEntry2 instanceof ValueBoxEntry) {
                    string4 = Util.javaName(symtabEntry2);
                }
                printWriter.println("    " + string2 + '.' + string3 + " = (" + string4 + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, true) + ".get_instance ());");
            } else {
                printWriter.println(string + string2 + '.' + string3 + " = " + Util.helperName(symtabEntry2, true) + ".read (istream);");
            }
            ++n4;
        }
        return n2;
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    ((org.omg.CORBA_2_3.portable.OutputStream) ostream).write_value (value, get_instance());");
        printWriter.println("  }");
        printWriter.println();
        if (!((ValueEntry)symtabEntry).isCustom()) {
            printWriter.println("  public static void _write (org.omg.CORBA.portable.OutputStream ostream, " + Util.javaName(symtabEntry) + " value)");
            printWriter.println("  {");
            this.write(0, "    ", "value", symtabEntry, printWriter);
            printWriter.println("  }");
            printWriter.println();
        }
        printWriter.println("  public void write_value (org.omg.CORBA.portable.OutputStream ostream, java.io.Serializable obj)");
        printWriter.println("  {");
        if (((ValueEntry)symtabEntry).isCustom()) {
            printWriter.println("    throw new org.omg.CORBA.BAD_OPERATION (\"custom values should use marshal()\");");
        } else {
            String string = Util.javaName(symtabEntry);
            printWriter.println("    _write (ostream, (" + string + ") obj);");
        }
    }

    public int write(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        Object object;
        Vector vector = ((ValueEntry)symtabEntry).derivedFrom();
        if (vector != null && vector.size() != 0) {
            object = (ValueEntry)vector.elementAt(0);
            if (object == null) {
                return n2;
            }
            if (!Util.javaQualifiedName((SymtabEntry)object).equals("java.io.Serializable")) {
                printWriter.println(string + Util.helperName((SymtabEntry)object, true) + "._write (ostream, value);");
            }
        }
        int n3 = (object = ((ValueEntry)symtabEntry).state()) == null ? 0 : ((Vector)object).size();
        int n4 = 0;
        while (n4 < n3) {
            TypedefEntry typedefEntry = ((InterfaceState)((Vector)object).elementAt((int)n4)).entry;
            String string3 = typedefEntry.name();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StringEntry || !typedefEntry.arrayInfo().isEmpty()) {
                n2 = ((JavaGenerator)((Object)typedefEntry.generator())).write(n2, string, string2 + '.' + string3, typedefEntry, printWriter);
            } else {
                printWriter.println(string + Util.helperName(symtabEntry2, true) + ".write (ostream, " + string2 + '.' + string3 + ");");
            }
            ++n4;
        }
        return n2;
    }

    protected void writeAbstract() {
        SymtabEntry symtabEntry;
        this.stream.print("public interface " + this.v.name());
        if (this.v.derivedFrom().size() == 0) {
            this.stream.print(" extends org.omg.CORBA.portable.ValueBase");
        } else {
            int n2 = 0;
            while (n2 < this.v.derivedFrom().size()) {
                if (n2 == 0) {
                    this.stream.print(" extends ");
                } else {
                    this.stream.print(", ");
                }
                symtabEntry = (SymtabEntry)this.v.derivedFrom().elementAt(n2);
                this.stream.print(Util.javaName(symtabEntry));
                ++n2;
            }
        }
        if (this.v.supports().size() > 0) {
            this.stream.print(", ");
            symtabEntry = (SymtabEntry)this.v.supports().elementAt(0);
            this.stream.print(Util.javaName(symtabEntry));
        }
        this.stream.println();
        this.stream.println("{");
    }
}

