/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.util.Enumeration;
import java.util.Hashtable;

public class TCOffsets {
    private Hashtable tcs = new Hashtable();
    private int offset = 0;

    public int offset(String string) {
        Integer n2 = (Integer)this.tcs.get(string);
        return n2 == null ? -1 : n2;
    }

    public void set(SymtabEntry symtabEntry) {
        if (symtabEntry == null) {
            this.offset += 8;
        } else {
            this.tcs.put(symtabEntry.fullName(), new Integer(this.offset));
            this.offset += 4;
            String string = Util.stripLeadingUnderscoresFromID(symtabEntry.repositoryID().ID());
            if (symtabEntry instanceof InterfaceEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name());
            } else if (symtabEntry instanceof StructEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 4;
            } else if (symtabEntry instanceof UnionEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 12;
            } else if (symtabEntry instanceof EnumEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name()) + 4;
                Enumeration enumeration = ((EnumEntry)symtabEntry).elements().elements();
                while (enumeration.hasMoreElements()) {
                    this.offset += this.alignStrLen((String)enumeration.nextElement());
                }
            } else if (symtabEntry instanceof StringEntry) {
                this.offset += 4;
            } else if (symtabEntry instanceof TypedefEntry) {
                this.offset += this.alignStrLen(string) + this.alignStrLen(symtabEntry.name());
                if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
                    this.offset += 8;
                }
            }
        }
    }

    public int alignStrLen(String string) {
        int n2 = string.length() + 1;
        int n3 = 4 - n2 % 4;
        if (n3 == 4) {
            n3 = 0;
        }
        return n2 + n3 + 4;
    }

    public void setMember(SymtabEntry symtabEntry) {
        this.offset += this.alignStrLen(symtabEntry.name());
        if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
            this.offset += 4;
        }
    }

    public int currentOffset() {
        return this.offset;
    }

    public void bumpCurrentOffset(int n2) {
        this.offset += n2;
    }
}

