/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.File;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Stub
implements AuxGen {
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected Vector methodList = null;
    protected String classSuffix = "";
    protected boolean localStub = false;
    private boolean isAbstract = false;

    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        this.symbolTable = hashtable;
        this.i = (InterfaceEntry)symtabEntry;
        this.localStub = this.i.isLocalServant();
        this.isAbstract = this.i.isAbstract();
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.classSuffix = "Stub";
    }

    protected void openStream() {
        String string = '_' + this.i.name() + this.classSuffix;
        String string2 = Util.containerFullName(this.i.container());
        if (string2 != null && !string2.equals("")) {
            Util.mkdir(string2);
            string = string2 + '/' + string;
        }
        this.stream = Util.getStream(string.replace('/', File.separatorChar) + ".java", this.i);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)1);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        this.writeClassDeclaration();
        this.stream.println('{');
    }

    protected void writeClassDeclaration() {
        this.stream.print("public class _" + this.i.name() + this.classSuffix + " extends org.omg.CORBA.portable.ObjectImpl");
        this.stream.println(" implements " + Util.javaName(this.i));
    }

    protected void writeBody() {
        this.writeCtors();
        this.buildMethodList();
        this.writeMethods();
        this.writeCORBAObjectMethods();
        this.writeSerializationMethods();
    }

    protected void writeClosing() {
        this.stream.println("} // class _" + this.i.name() + this.classSuffix);
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        String string = this.i.name();
        if (this.localStub) {
            this.stream.println("  final public static java.lang.Class _opsClass = " + string + "Operations.class;");
            this.stream.println();
        }
        this.stream.println();
    }

    protected void buildMethodList() {
        this.methodList = new Vector();
        this.buildMethodList(this.i);
    }

    private void buildMethodList(InterfaceEntry interfaceEntry) {
        Enumeration enumeration = interfaceEntry.methods().elements();
        while (enumeration.hasMoreElements()) {
            this.addMethod((MethodEntry)enumeration.nextElement());
        }
        Enumeration enumeration2 = interfaceEntry.derivedFrom().elements();
        while (enumeration2.hasMoreElements()) {
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)enumeration2.nextElement();
            if (interfaceEntry2.name().equals("Object")) continue;
            this.buildMethodList(interfaceEntry2);
        }
    }

    private void addMethod(MethodEntry methodEntry) {
        if (!this.methodList.contains(methodEntry)) {
            this.methodList.addElement(methodEntry);
        }
    }

    protected void writeMethods() {
        int n2 = this.methodList.size();
        Enumeration enumeration = this.methodList.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (!(e2 instanceof AttributeEntry) || ((AttributeEntry)e2).readOnly()) continue;
            ++n2;
        }
        if (((Arguments)Compile.compiler.arguments).LocalOptimization && !this.isAbstract) {
            this.stream.println("    final public static java.lang.Class _opsClass =");
            this.stream.println("        " + this.i.name() + "Operations.class;");
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.methodList.size()) {
            MethodEntry methodEntry = (MethodEntry)this.methodList.elementAt(n4);
            if (!this.localStub) {
                ((MethodGen)methodEntry.generator()).stub(this.i.name(), this.isAbstract, this.symbolTable, methodEntry, this.stream, n3);
            } else {
                ((MethodGen)methodEntry.generator()).localstub(this.symbolTable, methodEntry, this.stream, n3, this.i);
            }
            n3 = methodEntry instanceof AttributeEntry && !((AttributeEntry)methodEntry).readOnly() ? (n3 += 2) : ++n3;
            ++n4;
        }
    }

    private void buildIDList(InterfaceEntry interfaceEntry, Vector vector) {
        if (!interfaceEntry.fullName().equals("org/omg/CORBA/Object")) {
            String string = Util.stripLeadingUnderscoresFromID(interfaceEntry.repositoryID().ID());
            if (!vector.contains(string)) {
                vector.addElement(string);
            }
            Enumeration enumeration = interfaceEntry.derivedFrom().elements();
            while (enumeration.hasMoreElements()) {
                this.buildIDList((InterfaceEntry)enumeration.nextElement(), vector);
            }
        }
    }

    private void writeIDs() {
        Vector vector = new Vector();
        this.buildIDList(this.i, vector);
        Enumeration enumeration = vector.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (bl) {
                bl = false;
            } else {
                this.stream.println(", ");
            }
            this.stream.print("    \"" + (String)enumeration.nextElement() + '\"');
        }
    }

    protected void writeCORBAObjectMethods() {
        this.stream.println("  // Type-specific CORBA::Object operations");
        this.stream.println("  private static String[] __ids = {");
        this.writeIDs();
        this.stream.println("};");
        this.stream.println();
        this.stream.println("  public String[] _ids ()");
        this.stream.println("  {");
        this.stream.println("    return (String[])__ids.clone ();");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeSerializationMethods() {
        this.stream.println("  private void readObject (java.io.ObjectInputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String str = s.readUTF ();");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     org.omg.CORBA.Object obj = org.omg.CORBA.ORB.init (args, props).string_to_object (str);");
        this.stream.println("     org.omg.CORBA.portable.Delegate delegate = ((org.omg.CORBA.portable.ObjectImpl) obj)._get_delegate ();");
        this.stream.println("     _set_delegate (delegate);");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  private void writeObject (java.io.ObjectOutputStream s) throws java.io.IOException");
        this.stream.println("  {");
        this.stream.println("     String[] args = null;");
        this.stream.println("     java.util.Properties props = null;");
        this.stream.println("     String str = org.omg.CORBA.ORB.init (args, props).object_to_string (this);");
        this.stream.println("     s.writeUTF (str);");
        this.stream.println("  }");
    }
}

