/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StructGen
implements com.sun.tools.corba.se.idl.StructGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected StructEntry s = null;
    protected PrintWriter stream = null;
    protected boolean thisIsReallyAnException = false;
    private boolean[] memberIsPrimitive;
    private boolean[] memberIsInterface;
    private boolean[] memberIsTypedef;

    public StructGen() {
    }

    protected StructGen(boolean bl) {
        this.thisIsReallyAnException = bl;
    }

    public void generate(Hashtable hashtable, StructEntry structEntry, PrintWriter printWriter) {
        this.symbolTable = hashtable;
        this.s = structEntry;
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
        this.generateContainedTypes();
    }

    protected void init() {
    }

    protected void openStream() {
        this.stream = Util.stream(this.s, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.s);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.s);
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.s);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.s.comment() != null) {
            this.s.comment().generate("", this.stream);
        }
        this.stream.print("public final class " + this.s.name());
        if (this.thisIsReallyAnException) {
            this.stream.print(" extends org.omg.CORBA.UserException");
        } else {
            this.stream.print(" implements org.omg.CORBA.portable.IDLEntity");
        }
        this.stream.println();
        this.stream.println("{");
    }

    protected void writeBody() {
        this.writeMembers();
        this.writeCtors();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.s.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void generateContainedTypes() {
        Enumeration enumeration = this.s.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof SequenceEntry) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeMembers() {
        int n2 = this.s.members().size();
        this.memberIsPrimitive = new boolean[n2];
        this.memberIsInterface = new boolean[n2];
        this.memberIsTypedef = new boolean[n2];
        int n3 = 0;
        while (n3 < this.s.members().size()) {
            SymtabEntry symtabEntry = (SymtabEntry)this.s.members().elementAt(n3);
            this.memberIsPrimitive[n3] = symtabEntry.type() instanceof PrimitiveEntry;
            this.memberIsInterface[n3] = symtabEntry.type() instanceof InterfaceEntry;
            this.memberIsTypedef[n3] = symtabEntry.type() instanceof TypedefEntry;
            Util.fillInfo(symtabEntry);
            if (symtabEntry.comment() != null) {
                symtabEntry.comment().generate("  ", this.stream);
            }
            Util.writeInitializer("  public ", symtabEntry.name(), "", symtabEntry, this.stream);
            ++n3;
        }
    }

    protected void writeCtors() {
        this.stream.println();
        this.stream.println("  public " + this.s.name() + " ()");
        this.stream.println("  {");
        if (this.thisIsReallyAnException) {
            this.stream.println("    super(" + this.s.name() + "Helper.id());");
        }
        this.stream.println("  } // ctor");
        this.writeInitializationCtor(true);
        if (this.thisIsReallyAnException) {
            this.writeInitializationCtor(false);
        }
    }

    private void writeInitializationCtor(boolean bl) {
        if (!bl || this.s.members().size() > 0) {
            this.stream.println();
            this.stream.print("  public " + this.s.name() + " (");
            boolean bl2 = true;
            if (!bl) {
                this.stream.print("String $reason");
                bl2 = false;
            }
            int n2 = 0;
            while (n2 < this.s.members().size()) {
                SymtabEntry symtabEntry = (SymtabEntry)this.s.members().elementAt(n2);
                if (bl2) {
                    bl2 = false;
                } else {
                    this.stream.print(", ");
                }
                this.stream.print(Util.javaName(symtabEntry) + " _" + symtabEntry.name());
                ++n2;
            }
            this.stream.println(")");
            this.stream.println("  {");
            if (this.thisIsReallyAnException) {
                if (bl) {
                    this.stream.println("    super(" + this.s.name() + "Helper.id());");
                } else {
                    this.stream.println("    super(" + this.s.name() + "Helper.id() + \"  \" + $reason);");
                }
            }
            int n3 = 0;
            while (n3 < this.s.members().size()) {
                SymtabEntry symtabEntry = (SymtabEntry)this.s.members().elementAt(n3);
                this.stream.println("    " + symtabEntry.name() + " = _" + symtabEntry.name() + ";");
                ++n3;
            }
            this.stream.println("  } // ctor");
        }
        this.stream.println();
    }

    public int helperType(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        TCOffsets tCOffsets2 = new TCOffsets();
        tCOffsets2.set(symtabEntry);
        int n3 = tCOffsets2.currentOffset();
        StructEntry structEntry = (StructEntry)symtabEntry;
        String string3 = "_members" + n2++;
        printWriter.println(string + "org.omg.CORBA.StructMember[] " + string3 + " = new org.omg.CORBA.StructMember [" + structEntry.members().size() + "];");
        String string4 = "_tcOf" + string3;
        printWriter.println(string + "org.omg.CORBA.TypeCode " + string4 + " = null;");
        int n4 = 0;
        while (n4 < structEntry.members().size()) {
            TypedefEntry typedefEntry = (TypedefEntry)structEntry.members().elementAt(n4);
            String string5 = typedefEntry.name();
            n2 = ((JavaGenerator)((Object)typedefEntry.generator())).type(n2, string, tCOffsets2, string4, typedefEntry, printWriter);
            printWriter.println(string + string3 + '[' + n4 + "] = new org.omg.CORBA.StructMember (");
            printWriter.println(string + "  \"" + Util.stripLeadingUnderscores(string5) + "\",");
            printWriter.println(string + "  " + string4 + ',');
            printWriter.println(string + "  null);");
            int n5 = tCOffsets2.currentOffset();
            tCOffsets2 = new TCOffsets();
            tCOffsets2.set(symtabEntry);
            tCOffsets2.bumpCurrentOffset(n5 - n3);
            ++n4;
        }
        tCOffsets.bumpCurrentOffset(tCOffsets2.currentOffset());
        printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_" + (this.thisIsReallyAnException ? "exception" : "struct") + "_tc (" + Util.helperName(structEntry, true) + ".id (), \"" + Util.stripLeadingUnderscores(symtabEntry.name()) + "\", " + string3 + ");");
        return n2;
    }

    public int type(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n2;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println("    " + string + " value = new " + string + " ();");
        this.read(0, "    ", "value", symtabEntry, printWriter);
        printWriter.println("    return value;");
    }

    public int read(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (this.thisIsReallyAnException) {
            printWriter.println(string + "// read and discard the repository ID");
            printWriter.println(string + "istream.read_string ();");
        }
        Enumeration enumeration = ((StructEntry)symtabEntry).members().elements();
        while (enumeration.hasMoreElements()) {
            TypedefEntry typedefEntry = (TypedefEntry)enumeration.nextElement();
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof TypedefEntry) {
                n2 = ((JavaGenerator)((Object)typedefEntry.generator())).read(n2, string, string2 + '.' + typedefEntry.name(), typedefEntry, printWriter);
                continue;
            }
            if (symtabEntry2 instanceof ValueBoxEntry) {
                Vector vector = ((ValueBoxEntry)symtabEntry2).state();
                TypedefEntry typedefEntry2 = ((InterfaceState)vector.elementAt((int)0)).entry;
                SymtabEntry symtabEntry3 = typedefEntry2.type();
                String string3 = null;
                String string4 = null;
                if (symtabEntry3 instanceof SequenceEntry || symtabEntry3 instanceof StringEntry || !typedefEntry2.arrayInfo().isEmpty()) {
                    string3 = Util.javaName(symtabEntry3);
                    string4 = Util.helperName(symtabEntry2, true);
                } else {
                    string3 = Util.javaName(symtabEntry2);
                    string4 = Util.helperName(symtabEntry2, true);
                }
                if (Util.corbaLevel(2.4f, 99.0f)) {
                    printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + string3 + ") " + string4 + ".read (istream);");
                    continue;
                }
                printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + string3 + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + string4 + ".get_instance ());");
                continue;
            }
            if (symtabEntry2 instanceof ValueEntry && !Util.corbaLevel(2.4f, 99.0f)) {
                printWriter.println(string + string2 + '.' + typedefEntry.name() + " = (" + Util.javaName(symtabEntry2) + ") ((org.omg.CORBA_2_3.portable.InputStream)istream).read_value (" + Util.helperName(symtabEntry2, false) + ".get_instance ());");
                continue;
            }
            printWriter.println(string + string2 + '.' + typedefEntry.name() + " = " + Util.helperName(typedefEntry.type(), true) + ".read (istream);");
        }
        return n2;
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        this.write(0, "    ", "value", symtabEntry, printWriter);
    }

    public int write(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        if (this.thisIsReallyAnException) {
            printWriter.println(string + "// write the repository ID");
            printWriter.println(string + "ostream.write_string (id ());");
        }
        Vector vector = ((StructEntry)symtabEntry).members();
        int n3 = 0;
        while (n3 < vector.size()) {
            TypedefEntry typedefEntry = (TypedefEntry)vector.elementAt(n3);
            SymtabEntry symtabEntry2 = typedefEntry.type();
            if (!typedefEntry.arrayInfo().isEmpty() || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry) {
                n2 = ((JavaGenerator)((Object)typedefEntry.generator())).write(n2, "    ", string2 + '.' + typedefEntry.name(), typedefEntry, printWriter);
            } else if ((symtabEntry2 instanceof ValueEntry || symtabEntry2 instanceof ValueBoxEntry) && !Util.corbaLevel(2.4f, 99.0f)) {
                printWriter.println(string + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_value ((java.io.Serializable) " + string2 + '.' + typedefEntry.name() + ", " + Util.helperName(typedefEntry.type(), true) + ".get_instance ());");
            } else {
                printWriter.println(string + Util.helperName(typedefEntry.type(), true) + ".write (ostream, " + string2 + '.' + typedefEntry.name() + ");");
            }
            ++n3;
        }
        return n2;
    }
}

