/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.Arguments;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.MethodGen;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class InterfaceGen
implements com.sun.tools.corba.se.idl.InterfaceGen,
JavaGenerator {
    protected int emit = 0;
    protected Factories factories = null;
    protected Hashtable symbolTable = null;
    protected InterfaceEntry i = null;
    protected PrintWriter stream = null;
    protected static final int SIGNATURE = 1;
    protected static final int OPERATIONS = 2;
    protected int intfType = 0;

    public void generate(Hashtable hashtable, InterfaceEntry interfaceEntry, PrintWriter printWriter) {
        if (!this.isPseudo(interfaceEntry)) {
            this.symbolTable = hashtable;
            this.i = interfaceEntry;
            this.init();
            if (!interfaceEntry.isLocalSignature()) {
                if (!interfaceEntry.isLocal()) {
                    this.generateSkeleton();
                    Arguments arguments = (Arguments)Compile.compiler.arguments;
                    if (arguments.TIEServer) {
                        if (arguments.emit == 3) {
                            arguments.TIEServer = false;
                            this.generateSkeleton();
                            arguments.TIEServer = true;
                        }
                    }
                    this.generateStub();
                }
                this.generateHolder();
                this.generateHelper();
            }
            this.intfType = 1;
            this.generateInterface();
            this.intfType = 2;
            this.generateInterface();
            this.intfType = 0;
        }
    }

    protected void init() {
        this.emit = ((Arguments)Compile.compiler.arguments).emit;
        this.factories = (Factories)Compile.compiler.factories();
    }

    protected void generateSkeleton() {
        if (this.emit != 1) {
            this.factories.skeleton().generate(this.symbolTable, this.i);
        }
    }

    protected void generateStub() {
        if (this.emit != 2) {
            this.factories.stub().generate(this.symbolTable, this.i);
        }
    }

    protected void generateHelper() {
        if (this.emit != 2) {
            this.factories.helper().generate(this.symbolTable, this.i);
        }
    }

    protected void generateHolder() {
        if (this.emit != 2) {
            this.factories.holder().generate(this.symbolTable, this.i);
        }
    }

    protected void generateInterface() {
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        if (this.intfType == 2) {
            this.writeOperationsBody();
        }
        if (this.intfType == 1) {
            this.writeSignatureBody();
        }
        this.writeClosing();
        this.closeStream();
    }

    protected void openStream() {
        if (this.i.isAbstract() || this.intfType == 1) {
            this.stream = Util.stream(this.i, ".java");
        } else if (this.intfType == 2) {
            this.stream = Util.stream(this.i, "Operations.java");
        }
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.i, (short)0);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        if (this.i.comment() != null) {
            this.i.comment().generate("", this.stream);
        }
        String string = this.i.name();
        if (this.intfType == 1) {
            this.writeSignatureHeading();
        } else if (this.intfType == 2) {
            this.writeOperationsHeading();
        }
        this.stream.println();
        this.stream.println('{');
    }

    protected void writeSignatureHeading() {
        String string = this.i.name();
        this.stream.print("public interface " + string + " extends " + string + "Operations, ");
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.i.derivedFrom().size()) {
            if (bl) {
                bl = false;
            } else {
                this.stream.print(", ");
            }
            InterfaceEntry interfaceEntry = (InterfaceEntry)this.i.derivedFrom().elementAt(n2);
            this.stream.print(Util.javaName(interfaceEntry));
            if (!interfaceEntry.isAbstract()) {
                bl2 = true;
            }
            ++n2;
        }
        if (!bl2) {
            this.stream.print(", org.omg.CORBA.Object, org.omg.CORBA.portable.IDLEntity ");
        } else if (this.i.derivedFrom().size() == 1) {
            this.stream.print(", org.omg.CORBA.portable.IDLEntity ");
        }
    }

    protected void writeOperationsHeading() {
        this.stream.print("public interface " + this.i.name());
        if (!this.i.isAbstract()) {
            this.stream.print("Operations ");
        } else if (this.i.derivedFrom().size() == 0) {
            this.stream.print(" extends org.omg.CORBA.portable.IDLEntity");
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.i.derivedFrom().size()) {
            InterfaceEntry interfaceEntry = (InterfaceEntry)this.i.derivedFrom().elementAt(n2);
            String string = Util.javaName(interfaceEntry);
            if (!string.equals("org.omg.CORBA.Object")) {
                if (bl) {
                    bl = false;
                    this.stream.print(" extends ");
                } else {
                    this.stream.print(", ");
                }
                if (interfaceEntry.isAbstract() || this.i.isAbstract()) {
                    this.stream.print(string);
                } else {
                    this.stream.print(string + "Operations");
                }
            }
            ++n2;
        }
    }

    protected void writeOperationsBody() {
        Enumeration enumeration = this.i.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof MethodEntry) {
                MethodEntry methodEntry = (MethodEntry)symtabEntry;
                ((MethodGen)methodEntry.generator()).interfaceMethod(this.symbolTable, methodEntry, this.stream);
                continue;
            }
            if (symtabEntry instanceof ConstEntry) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeSignatureBody() {
        Enumeration enumeration = this.i.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (!(symtabEntry instanceof ConstEntry)) continue;
            symtabEntry.generate(this.symbolTable, this.stream);
        }
    }

    protected void writeClosing() {
        String string = this.i.name();
        if (!this.i.isAbstract() && this.intfType == 2) {
            string = string + "Operations";
        }
        this.stream.println("} // interface " + string);
    }

    protected void closeStream() {
        this.stream.close();
    }

    public int helperType(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
        tCOffsets.set(symtabEntry);
        if (symtabEntry.fullName().equals("org/omg/CORBA/Object")) {
            printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_objref);");
        } else {
            printWriter.println(string + string2 + " = org.omg.CORBA.ORB.init ().create_interface_tc (" + Util.helperName(interfaceEntry, true) + ".id (), " + '\"' + Util.stripLeadingUnderscores(symtabEntry.name()) + "\");");
        }
        return n2;
    }

    public int type(int n2, String string, TCOffsets tCOffsets, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, true) + ".type ();");
        return n2;
    }

    public void helperRead(String string, SymtabEntry symtabEntry, PrintWriter printWriter) {
        InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
        if (interfaceEntry.isAbstract()) {
            printWriter.println("    return narrow (((org.omg.CORBA_2_3.portable.InputStream)istream).read_abstract_interface (_" + interfaceEntry.name() + "Stub.class));");
        } else {
            printWriter.println("    return narrow (istream.read_Object (_" + interfaceEntry.name() + "Stub.class));");
        }
    }

    public void helperWrite(SymtabEntry symtabEntry, PrintWriter printWriter) {
        this.write(0, "    ", "value", symtabEntry, printWriter);
    }

    public int read(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
        if (symtabEntry.fullName().equals("org/omg/CORBA/Object")) {
            printWriter.println(string + string2 + " = istream.read_Object (_" + interfaceEntry.name() + "Stub.class);");
        } else {
            printWriter.println(string + string2 + " = " + Util.helperName(symtabEntry, false) + ".narrow (istream.read_Object (_" + interfaceEntry.name() + "Stub.class));");
        }
        return n2;
    }

    public int write(int n2, String string, String string2, SymtabEntry symtabEntry, PrintWriter printWriter) {
        InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
        if (interfaceEntry.isAbstract()) {
            printWriter.println(string + "((org.omg.CORBA_2_3.portable.OutputStream)ostream).write_abstract_interface ((java.lang.Object) " + string2 + ");");
        } else {
            printWriter.println(string + "ostream.write_Object ((org.omg.CORBA.Object) " + string2 + ");");
        }
        return n2;
    }

    private boolean isPseudo(InterfaceEntry interfaceEntry) {
        String string = interfaceEntry.fullName();
        if (string.equalsIgnoreCase("CORBA/TypeCode")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/Principal")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/ORB")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/Any")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/Context")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/ContextList")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/DynamicImplementation")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/Environment")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/ExceptionList")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/NVList")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/NamedValue")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/Request")) {
            return true;
        }
        if (string.equalsIgnoreCase("CORBA/ServerRequest")) {
            return true;
        }
        return string.equalsIgnoreCase("CORBA/UserException");
    }
}

