/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.SymtabEntry;
import java.security.MessageDigest;
import java.util.Hashtable;

public class ValueRepositoryId {
    private MessageDigest sha;
    private int index;
    private Hashtable types;
    private String hashcode;

    public ValueRepositoryId() {
        try {
            this.sha = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.index = 0;
        this.types = new Hashtable();
        this.hashcode = null;
    }

    public void addValue(int n2) {
        this.sha.update((byte)(n2 >> 24 & 0xF));
        this.sha.update((byte)(n2 >> 16 & 0xF));
        this.sha.update((byte)(n2 >> 8 & 0xF));
        this.sha.update((byte)(n2 & 0xF));
        ++this.index;
    }

    public void addType(SymtabEntry symtabEntry) {
        this.types.put(symtabEntry, new Integer(this.index));
    }

    public boolean isNewType(SymtabEntry symtabEntry) {
        Object v2 = this.types.get(symtabEntry);
        if (v2 == null) {
            this.addType(symtabEntry);
            return true;
        }
        this.addValue(-1);
        this.addValue((Integer)v2);
        return false;
    }

    public String getHashcode() {
        if (this.hashcode == null) {
            byte[] byArray = this.sha.digest();
            this.hashcode = ValueRepositoryId.hexOf(byArray[0]) + ValueRepositoryId.hexOf(byArray[1]) + ValueRepositoryId.hexOf(byArray[2]) + ValueRepositoryId.hexOf(byArray[3]) + ValueRepositoryId.hexOf(byArray[4]) + ValueRepositoryId.hexOf(byArray[5]) + ValueRepositoryId.hexOf(byArray[6]) + ValueRepositoryId.hexOf(byArray[7]);
        }
        return this.hashcode;
    }

    private static String hexOf(byte by) {
        int n2 = by >> 4 & 0xF;
        int n3 = by & 0xF;
        return "0123456789ABCDEF".substring(n2, n2 + 1) + "0123456789ABCDEF".substring(n3, n3 + 1);
    }
}

