/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Comment;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.InvalidCharacter;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Parser;
import com.sun.tools.corba.se.idl.ScannerData;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.Token;
import com.sun.tools.corba.se.idl.Util;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

class Scanner {
    static final int Star = 0;
    static final int Plus = 1;
    static final int Dot = 2;
    static final int None = 3;
    private int BOL;
    private ScannerData data = new ScannerData();
    private Stack dataStack = new Stack();
    private Vector keywords = new Vector();
    private Vector openEndedKeywords = new Vector();
    private Vector wildcardKeywords = new Vector();
    private boolean verbose;
    boolean escapedOK = true;
    private boolean emitAll;
    private float corbaLevel;
    private boolean debug;

    Scanner(IncludeEntry includeEntry, String[] stringArray, boolean bl, boolean bl2, float f2, boolean bl3) throws IOException {
        this.readFile(includeEntry);
        this.verbose = bl;
        this.emitAll = bl2;
        this.sortKeywords(stringArray);
        this.corbaLevel = f2;
        this.debug = bl3;
    }

    void sortKeywords(String[] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (this.wildcardAtEitherEnd(stringArray[n2])) {
                this.openEndedKeywords.addElement(stringArray[n2]);
            } else if (this.wildcardsInside(stringArray[n2])) {
                this.wildcardKeywords.addElement(stringArray[n2]);
            } else {
                this.keywords.addElement(stringArray[n2]);
            }
            ++n2;
        }
    }

    private boolean wildcardAtEitherEnd(String string) {
        return string.startsWith("*") || string.startsWith("+") || string.startsWith(".") || string.endsWith("*") || string.endsWith("+") || string.endsWith(".");
    }

    private boolean wildcardsInside(String string) {
        return string.indexOf("*") > 0 || string.indexOf("+") > 0 || string.indexOf(".") > 0;
    }

    void readFile(IncludeEntry includeEntry) throws IOException {
        String string = includeEntry.name();
        string = string.substring(1, string.length() - 1);
        this.readFile(includeEntry, string);
    }

    void readFile(IncludeEntry includeEntry, String string) throws IOException {
        this.data.fileEntry = includeEntry;
        this.data.filename = string;
        File file = new File(this.data.filename);
        int n2 = (int)file.length();
        FileReader fileReader = new FileReader(file);
        String string2 = System.getProperty("line.separator");
        this.data.fileBytes = new char[n2 + string2.length()];
        fileReader.read(this.data.fileBytes, 0, n2);
        fileReader.close();
        int n3 = 0;
        while (n3 < string2.length()) {
            this.data.fileBytes[n2 + n3] = string2.charAt(n3);
            ++n3;
        }
        this.readChar();
    }

    Token getToken() throws IOException {
        Token token = null;
        String string = new String("");
        while (token == null) {
            try {
                this.data.oldIndex = this.data.fileIndex;
                this.data.oldLine = this.data.line;
                if (this.data.ch <= ' ') {
                    this.skipWhiteSpace();
                    continue;
                }
                if (this.data.ch == 'L') {
                    this.readChar();
                    if (this.data.ch == '\'') {
                        token = this.getCharacterToken(true);
                        this.readChar();
                        continue;
                    }
                    if (this.data.ch == '\"') {
                        this.readChar();
                        token = new Token(204, this.getUntil('\"'), true);
                        this.readChar();
                        continue;
                    }
                    this.unread(this.data.ch);
                    this.unread('L');
                    this.readChar();
                }
                if (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z' || this.data.ch == '_' || Character.isLetter(this.data.ch)) {
                    token = this.getString();
                    continue;
                }
                if (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch == '.') {
                    token = this.getNumber();
                    continue;
                }
                switch (this.data.ch) {
                    case ';': {
                        token = new Token(100);
                        break;
                    }
                    case '{': {
                        token = new Token(101);
                        break;
                    }
                    case '}': {
                        token = new Token(102);
                        break;
                    }
                    case ':': {
                        this.readChar();
                        if (this.data.ch == ':') {
                            token = new Token(124);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(103);
                        break;
                    }
                    case ',': {
                        token = new Token(104);
                        break;
                    }
                    case '=': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(130);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(105);
                        break;
                    }
                    case '+': {
                        token = new Token(106);
                        break;
                    }
                    case '-': {
                        token = new Token(107);
                        break;
                    }
                    case '(': {
                        token = new Token(108);
                        break;
                    }
                    case ')': {
                        token = new Token(109);
                        break;
                    }
                    case '<': {
                        this.readChar();
                        if (this.data.ch == '<') {
                            token = new Token(125);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(133);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(110);
                        break;
                    }
                    case '>': {
                        this.readChar();
                        if (this.data.ch == '>') {
                            token = new Token(126);
                            break;
                        }
                        if (this.data.ch == '=') {
                            token = new Token(132);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(111);
                        break;
                    }
                    case '[': {
                        token = new Token(112);
                        break;
                    }
                    case ']': {
                        token = new Token(113);
                        break;
                    }
                    case '\'': {
                        token = this.getCharacterToken(false);
                        break;
                    }
                    case '\"': {
                        this.readChar();
                        token = new Token(204, this.getUntil('\"'));
                        break;
                    }
                    case '\\': {
                        this.readChar();
                        if (this.data.ch == '\n' || this.data.ch == '\r') {
                            token = null;
                            break;
                        }
                        token = new Token(116);
                        break;
                    }
                    case '|': {
                        this.readChar();
                        if (this.data.ch == '|') {
                            token = new Token(134);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(117);
                        break;
                    }
                    case '^': {
                        token = new Token(118);
                        break;
                    }
                    case '&': {
                        this.readChar();
                        if (this.data.ch == '&') {
                            token = new Token(135);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(119);
                        break;
                    }
                    case '*': {
                        token = new Token(120);
                        break;
                    }
                    case '/': {
                        this.readChar();
                        if (this.data.ch == '/') {
                            string = this.getLineComment();
                            break;
                        }
                        if (this.data.ch == '*') {
                            string = this.getBlockComment();
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(121);
                        break;
                    }
                    case '%': {
                        token = new Token(122);
                        break;
                    }
                    case '~': {
                        token = new Token(123);
                        break;
                    }
                    case '#': {
                        token = this.getDirective();
                        break;
                    }
                    case '!': {
                        this.readChar();
                        if (this.data.ch == '=') {
                            token = new Token(131);
                            break;
                        }
                        this.unread(this.data.ch);
                        token = new Token(129);
                        break;
                    }
                    case '?': {
                        try {
                            token = this.replaceTrigraph();
                            break;
                        }
                        catch (InvalidCharacter invalidCharacter) {
                            // empty catch block
                        }
                    }
                    default: {
                        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
                    }
                }
                this.readChar();
            }
            catch (EOFException eOFException) {
                token = new Token(999);
            }
        }
        token.comment = new Comment(string);
        if (this.debug) {
            System.out.println("Token: " + token);
        }
        return token;
    }

    void scanString(String string) {
        this.dataStack.push(this.data);
        this.data = new ScannerData(this.data);
        this.data.fileIndex = 0;
        this.data.oldIndex = 0;
        int n2 = string.length();
        this.data.fileBytes = new char[n2];
        string.getChars(0, n2, this.data.fileBytes, 0);
        this.data.macrodata = true;
        try {
            this.readChar();
        }
        catch (IOException iOException) {}
    }

    void scanIncludedFile(IncludeEntry includeEntry, String string, boolean bl) throws IOException {
        this.dataStack.push(this.data);
        this.data = new ScannerData();
        this.data.indent = ((ScannerData)this.dataStack.peek()).indent + ' ';
        this.data.includeIsImport = bl;
        try {
            this.readFile(includeEntry, string);
            if (!this.emitAll && bl) {
                SymtabEntry.enteringInclude();
            }
            Parser.enteringInclude();
            if (this.verbose) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parsing", string));
            }
        }
        catch (IOException iOException) {
            this.data = (ScannerData)this.dataStack.pop();
            throw iOException;
        }
    }

    private void unread(char c2) {
        if (c2 == '\n' && !this.data.macrodata) {
            --this.data.line;
        }
        --this.data.fileIndex;
    }

    void readChar() throws IOException {
        if (this.data.fileIndex >= this.data.fileBytes.length) {
            if (this.dataStack.empty()) {
                throw new EOFException();
            }
            if (!this.data.macrodata) {
                if (!this.emitAll && this.data.includeIsImport) {
                    SymtabEntry.exitingInclude();
                }
                Parser.exitingInclude();
            }
            if (this.verbose && !this.data.macrodata) {
                System.out.println(this.data.indent + Util.getMessage("Compile.parseDone", this.data.filename));
            }
            this.data = (ScannerData)this.dataStack.pop();
        } else {
            this.data.ch = (char)(this.data.fileBytes[this.data.fileIndex++] & 0xFF);
            if (this.data.ch == '\n' && !this.data.macrodata) {
                ++this.data.line;
            }
        }
    }

    private String getWString() throws IOException {
        this.readChar();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.data.ch != '\"') {
            if (this.data.ch == '\\') {
                this.readChar();
                if (this.data.ch == 'u') {
                    int n2 = this.getNDigitHexNumber(4);
                    System.out.println("Got num: " + n2);
                    System.out.println("Which is: " + (char)n2);
                    stringBuffer.append((char)n2);
                    continue;
                }
                if (this.data.ch >= '0' && this.data.ch <= '7') {
                    stringBuffer.append((char)this.get3DigitOctalNumber());
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(this.data.ch);
            } else {
                stringBuffer.append(this.data.ch);
            }
            this.readChar();
        }
        return stringBuffer.toString();
    }

    private Token getCharacterToken(boolean bl) throws IOException {
        Token token = null;
        this.readChar();
        if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == 'x' || this.data.ch == 'u') {
                char c2 = this.data.ch;
                int n2 = this.getNDigitHexNumber(c2 == 'x' ? 2 : 4);
                return new Token(201, (char)n2 + "\\" + c2 + Integer.toString(n2, 16), bl);
            }
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                int n3 = this.get3DigitOctalNumber();
                return new Token(201, (char)n3 + "\\" + Integer.toString(n3, 8), bl);
            }
            return this.singleCharEscapeSequence(bl);
        }
        token = new Token(201, "" + this.data.ch + this.data.ch, bl);
        this.readChar();
        return token;
    }

    private Token singleCharEscapeSequence(boolean bl) throws IOException {
        Token token;
        if (this.data.ch == 'n') {
            token = new Token(201, "\n\\n", bl);
        } else if (this.data.ch == 't') {
            token = new Token(201, "\t\\t", bl);
        } else if (this.data.ch == 'v') {
            token = new Token(201, "\u000b\\v", bl);
        } else if (this.data.ch == 'b') {
            token = new Token(201, "\b\\b", bl);
        } else if (this.data.ch == 'r') {
            token = new Token(201, "\r\\r", bl);
        } else if (this.data.ch == 'f') {
            token = new Token(201, "\f\\f", bl);
        } else if (this.data.ch == 'a') {
            token = new Token(201, "\u0007\\a", bl);
        } else if (this.data.ch == '\\') {
            token = new Token(201, "\\\\\\", bl);
        } else if (this.data.ch == '?') {
            token = new Token(201, "?\\?", bl);
        } else if (this.data.ch == '\'') {
            token = new Token(201, "'\\'", bl);
        } else if (this.data.ch == '\"') {
            token = new Token(201, "\"\\\"", bl);
        } else {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        this.readChar();
        return token;
    }

    /*
     * Unable to fully structure code
     */
    private Token getString() throws IOException {
        var1_1 = new StringBuffer();
        var2_2 = false;
        var3_3 = new boolean[]{false};
        if (this.data.ch != '_') ** GOTO lbl14
        var1_1.append(this.data.ch);
        this.readChar();
        var2_2 = this.escapedOK;
        if (!var2_2 || this.data.ch != '_') ** GOTO lbl14
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
lbl-1000:
        // 1 sources

        {
            var1_1.append(this.data.ch);
            this.readChar();
lbl14:
            // 3 sources

            ** while (Character.isLetterOrDigit((char)this.data.ch) || this.data.ch == '_')
        }
lbl15:
        // 1 sources

        var4_4 = var1_1.toString();
        if (!var2_2 && (var5_5 = Token.makeKeywordToken(var4_4, this.corbaLevel, this.escapedOK, var3_3)) != null) {
            return var5_5;
        }
        var4_4 = this.getIdentifier(var4_4);
        if (this.data.ch == '(') {
            this.readChar();
            return new Token(81, var4_4, var2_2, var3_3[0], false);
        }
        return new Token(80, var4_4, var2_2, var3_3[0], false);
    }

    private boolean matchesClosedWildKeyword(String string) {
        boolean bl = true;
        String string2 = string;
        Enumeration enumeration = this.wildcardKeywords.elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n2 = 3;
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), "*+.", true);
            if (!stringTokenizer.hasMoreTokens() || !string2.startsWith(string3 = stringTokenizer.nextToken())) continue;
            string2 = string2.substring(string3.length());
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n3;
                string3 = stringTokenizer.nextToken();
                if (string3.equals("*")) {
                    n2 = 0;
                    continue;
                }
                if (string3.equals("+")) {
                    n2 = 1;
                    continue;
                }
                if (string3.equals(".")) {
                    n2 = 2;
                    continue;
                }
                if (n2 == 0) {
                    n3 = string2.indexOf(string3);
                    if (n3 >= 0) {
                        string2 = string2.substring(n3 + string3.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n2 == 1) {
                    n3 = string2.indexOf(string3);
                    if (n3 > 0) {
                        string2 = string2.substring(n3 + string3.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n2 != 2) continue;
                n3 = string2.indexOf(string3);
                if (n3 == 1) {
                    string2 = string2.substring(1 + string3.length());
                    continue;
                }
                bl = false;
            }
            if (bl && string2.equals("")) break;
        }
        return bl && string2.equals("");
    }

    private String matchesOpenWildcard(String string) {
        Enumeration enumeration = this.openEndedKeywords.elements();
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            int n2 = 3;
            boolean bl = true;
            String string3 = string;
            StringTokenizer stringTokenizer = new StringTokenizer((String)enumeration.nextElement(), "*+.", true);
            while (stringTokenizer.hasMoreTokens() && bl) {
                int n3;
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("*")) {
                    n2 = 0;
                    continue;
                }
                if (string4.equals("+")) {
                    n2 = 1;
                    continue;
                }
                if (string4.equals(".")) {
                    n2 = 2;
                    continue;
                }
                if (n2 == 0) {
                    n2 = 3;
                    n3 = string3.lastIndexOf(string4);
                    if (n3 >= 0) {
                        string3 = this.blankOutMatch(string3, n3, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n2 == 1) {
                    n2 = 3;
                    n3 = string3.lastIndexOf(string4);
                    if (n3 > 0) {
                        string3 = this.blankOutMatch(string3, n3, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n2 == 2) {
                    n2 = 3;
                    n3 = string3.lastIndexOf(string4);
                    if (n3 == 1) {
                        string3 = this.blankOutMatch(string3, 1, string4.length());
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (n2 != 3) continue;
                if (string3.startsWith(string4)) {
                    string3 = this.blankOutMatch(string3, 0, string4.length());
                    continue;
                }
                bl = false;
            }
            if (!(!bl || n2 == 0 || n2 == 1 && string3.lastIndexOf(32) != string3.length() - 1 || n2 == 2 && string3.lastIndexOf(32) == string3.length() - 2 || n2 == 3 && string3.lastIndexOf(32) == string3.length() - 1)) {
                bl = false;
            }
            if (!bl) continue;
            string2 = string2 + "_" + this.matchesOpenWildcard(string3.trim());
            break;
        }
        return string2;
    }

    private String blankOutMatch(String string, int n2, int n3) {
        char[] cArray = new char[n3];
        int n4 = 0;
        while (n4 < n3) {
            cArray[n4] = 32;
            ++n4;
        }
        return string.substring(0, n2) + new String(cArray) + string.substring(n2 + n3);
    }

    private String getIdentifier(String string) {
        if (this.keywords.contains(string)) {
            string = '_' + string;
        } else {
            String string2 = "";
            string2 = this.matchesClosedWildKeyword(string) ? "_" : this.matchesOpenWildcard(string);
            string = string2 + string;
        }
        return string;
    }

    private Token getDirective() throws IOException {
        this.readChar();
        String string = new String();
        while (this.data.ch >= 'a' && this.data.ch <= 'z' || this.data.ch >= 'A' && this.data.ch <= 'Z') {
            string = string + this.data.ch;
            this.readChar();
        }
        this.unread(this.data.ch);
        int n2 = 0;
        while (n2 < Token.Directives.length) {
            if (string.equals(Token.Directives[n2])) {
                return new Token(300 + n2);
            }
            ++n2;
        }
        return new Token(313, string);
    }

    private Token getNumber() throws IOException {
        if (this.data.ch == '.') {
            return this.getFractionNoInteger();
        }
        if (this.data.ch == '0') {
            return this.isItHex();
        }
        return this.getInteger();
    }

    private Token getFractionNoInteger() throws IOException {
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            return this.getFraction(".");
        }
        return new Token(127);
    }

    private Token getFraction(String string) throws IOException {
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            string = string + this.data.ch;
            this.readChar();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        return new Token(203, string);
    }

    /*
     * Unable to fully structure code
     */
    private Token getExponent(String var1_1) throws IOException {
        block1: {
            this.readChar();
            if (this.data.ch != '+' && this.data.ch != '-') break block1;
            var1_1 = var1_1 + this.data.ch;
            this.readChar();
            ** GOTO lbl11
        }
        if (this.data.ch >= '0' && this.data.ch <= '9') ** GOTO lbl11
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1 + this.data.ch;
            this.readChar();
lbl11:
            // 3 sources

            ** while (this.data.ch >= '0' && this.data.ch <= '9')
        }
lbl12:
        // 1 sources

        return new Token(203, var1_1);
    }

    private Token isItHex() throws IOException {
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction("0.");
        }
        if (this.data.ch == 'x' || this.data.ch == 'X') {
            return this.getHexNumber("0x");
        }
        if (this.data.ch == '8' || this.data.ch == '9') {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            return this.getOctalNumber();
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent("0E");
        }
        return new Token(202, "0");
    }

    private Token getOctalNumber() throws IOException {
        String string = "0" + this.data.ch;
        this.readChar();
        while (this.data.ch >= '0' && this.data.ch <= '9') {
            if (this.data.ch == '8' || this.data.ch == '9') {
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return new Token(202, string);
    }

    /*
     * Unable to fully structure code
     */
    private Token getHexNumber(String var1_1) throws IOException {
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F') ** GOTO lbl6
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1 + this.data.ch;
            this.readChar();
lbl6:
            // 2 sources

            ** while (this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F')
        }
lbl7:
        // 1 sources

        return new Token(202, var1_1);
    }

    private int getNDigitHexNumber(int n2) throws IOException {
        this.readChar();
        if (!this.isHexChar(this.data.ch)) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
        }
        String string = "" + this.data.ch;
        this.readChar();
        int n3 = 2;
        while (n3 <= n2) {
            if (!this.isHexChar(this.data.ch)) break;
            string = string + this.data.ch;
            this.readChar();
            ++n3;
        }
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean isHexChar(char c2) {
        return this.data.ch >= '0' && this.data.ch <= '9' || this.data.ch >= 'a' && this.data.ch <= 'f' || this.data.ch >= 'A' && this.data.ch <= 'F';
    }

    private int get3DigitOctalNumber() throws IOException {
        char c2 = this.data.ch;
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch >= '0' && this.data.ch <= '7') {
            string = string + this.data.ch;
            this.readChar();
            if (this.data.ch >= '0' && this.data.ch <= '7') {
                string = string + this.data.ch;
                if (c2 > '3') {
                    throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), c2);
                }
                this.readChar();
            }
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), string.charAt(0));
        }
        return n2;
    }

    private Token getInteger() throws IOException {
        String string = "" + this.data.ch;
        this.readChar();
        if (this.data.ch == '.') {
            this.readChar();
            return this.getFraction(string + '.');
        }
        if (this.data.ch == 'e' || this.data.ch == 'E') {
            return this.getExponent(string + 'E');
        }
        if (this.data.ch >= '0' && this.data.ch <= '9') {
            while (this.data.ch >= '0' && this.data.ch <= '9') {
                string = string + this.data.ch;
                this.readChar();
                if (this.data.ch != '.') continue;
                this.readChar();
                return this.getFraction(string + '.');
            }
        }
        return new Token(202, string);
    }

    private Token replaceTrigraph() throws IOException {
        this.readChar();
        if (this.data.ch == '?') {
            this.readChar();
            if (this.data.ch == '=') {
                this.data.ch = (char)35;
            } else if (this.data.ch == '/') {
                this.data.ch = (char)92;
            } else if (this.data.ch == '\'') {
                this.data.ch = (char)94;
            } else if (this.data.ch == '(') {
                this.data.ch = (char)91;
            } else if (this.data.ch == ')') {
                this.data.ch = (char)93;
            } else if (this.data.ch == '!') {
                this.data.ch = (char)124;
            } else if (this.data.ch == '<') {
                this.data.ch = (char)123;
            } else if (this.data.ch == '>') {
                this.data.ch = (char)125;
            } else if (this.data.ch == '-') {
                this.data.ch = (char)126;
            } else {
                this.unread(this.data.ch);
                this.unread('?');
                throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
            }
            return this.getToken();
        }
        this.unread('?');
        throw new InvalidCharacter(this.data.filename, this.currentLine(), this.currentLineNumber(), this.currentLinePosition(), this.data.ch);
    }

    void skipWhiteSpace() throws IOException {
        while (this.data.ch <= ' ') {
            this.readChar();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void skipBlockComment() throws IOException {
        try {
            boolean bl = false;
            this.readChar();
            block2: while (true) {
                if (bl) {
                    return;
                }
                while (true) {
                    if (this.data.ch == '*') {
                        this.readChar();
                        if (this.data.ch != '/') continue block2;
                        return;
                    }
                    this.readChar();
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            ParseException.unclosedComment(this.data.filename);
            throw eOFException;
        }
    }

    void skipLineComment() throws IOException {
        while (this.data.ch != '\n') {
            this.readChar();
        }
    }

    private String getLineComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("/");
        while (this.data.ch != '\n') {
            if (this.data.ch != '\r') {
                stringBuffer.append(this.data.ch);
            }
            this.readChar();
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBlockComment() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("/*");
        try {
            boolean bl = false;
            this.readChar();
            stringBuffer.append(this.data.ch);
            block2: while (true) {
                if (bl) {
                    return stringBuffer.toString();
                }
                while (true) {
                    if (this.data.ch == '*') {
                        this.readChar();
                        stringBuffer.append(this.data.ch);
                        if (this.data.ch != '/') continue block2;
                        bl = true;
                        continue block2;
                    }
                    this.readChar();
                    stringBuffer.append(this.data.ch);
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            ParseException.unclosedComment(this.data.filename);
            throw eOFException;
        }
    }

    Token skipUntil(char c2) throws IOException {
        while (this.data.ch != c2) {
            if (this.data.ch == '/') {
                this.readChar();
                if (this.data.ch == '/') {
                    this.skipLineComment();
                    if (c2 != '\n') continue;
                    break;
                }
                if (this.data.ch != '*') continue;
                this.skipBlockComment();
                continue;
            }
            this.readChar();
        }
        return this.getToken();
    }

    String getUntil(char c2) throws IOException {
        String string = "";
        while (this.data.ch != c2) {
            string = this.appendToString(string, false, false);
        }
        return string;
    }

    String getUntil(char c2, char c3) throws IOException {
        String string = "";
        while (this.data.ch != c2 && this.data.ch != c3) {
            string = this.appendToString(string, false, false);
        }
        return string;
    }

    private String appendToString(String string, boolean bl, boolean bl2) throws IOException {
        if (this.data.ch == '/') {
            this.readChar();
            if (this.data.ch == '/') {
                this.skipLineComment();
            } else if (this.data.ch == '*') {
                this.skipBlockComment();
            } else {
                string = string + '/';
            }
        } else if (this.data.ch == '\\') {
            this.readChar();
            if (this.data.ch == '\n') {
                this.readChar();
            } else if (this.data.ch == '\r') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                }
            } else {
                string = string + '\\' + this.data.ch;
                this.readChar();
            }
        } else {
            if (!bl2 && this.data.ch == '\"') {
                this.readChar();
                string = string + '\"';
                while (this.data.ch != '\"') {
                    string = this.appendToString(string, true, false);
                }
            } else if (!bl && !bl2 && this.data.ch == '(') {
                this.readChar();
                string = string + '(';
                while (this.data.ch != ')') {
                    string = this.appendToString(string, false, false);
                }
            } else if (!bl && this.data.ch == '\'') {
                this.readChar();
                string = string + "'";
                while (this.data.ch != '\'') {
                    string = this.appendToString(string, false, true);
                }
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return string;
    }

    String getStringToEOL() throws IOException {
        String string = new String();
        while (this.data.ch != '\n') {
            if (this.data.ch == '\\') {
                this.readChar();
                if (this.data.ch == '\n') {
                    this.readChar();
                    continue;
                }
                if (this.data.ch == '\r') {
                    this.readChar();
                    if (this.data.ch != '\n') continue;
                    this.readChar();
                    continue;
                }
                string = string + this.data.ch;
                this.readChar();
                continue;
            }
            string = string + this.data.ch;
            this.readChar();
        }
        return string;
    }

    String filename() {
        return this.data.filename;
    }

    IncludeEntry fileEntry() {
        return this.data.fileEntry;
    }

    int currentLineNumber() {
        return this.data.line;
    }

    int lastTokenLineNumber() {
        return this.data.oldLine;
    }

    String currentLine() {
        this.BOL = this.data.fileIndex - 1;
        try {
            if (this.data.fileBytes[this.BOL - 1] == '\r' && this.data.fileBytes[this.BOL] == '\n') {
                this.BOL -= 2;
            } else if (this.data.fileBytes[this.BOL] == '\n') {
                --this.BOL;
            }
            while (this.data.fileBytes[this.BOL] != '\n') {
                --this.BOL;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.BOL = -1;
        }
        ++this.BOL;
        int n2 = this.data.fileIndex - 1;
        try {
            while (this.data.fileBytes[n2] != '\n' && this.data.fileBytes[n2] != '\r') {
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n2 = this.data.fileBytes.length;
        }
        if (this.BOL < n2) {
            return new String(this.data.fileBytes, this.BOL, n2 - this.BOL);
        }
        return "";
    }

    String lastTokenLine() {
        int n2 = this.data.fileIndex;
        this.data.fileIndex = this.data.oldIndex;
        String string = this.currentLine();
        this.data.fileIndex = n2;
        return string;
    }

    int currentLinePosition() {
        return this.data.fileIndex - this.BOL;
    }

    int lastTokenLinePosition() {
        return this.data.oldIndex - this.BOL;
    }
}

