/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.InvalidArgument;
import com.sun.tools.corba.se.idl.som.cff.FileLocator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Arguments {
    public String file = null;
    public boolean verbose = false;
    public boolean keepOldFiles = false;
    public boolean emitAll = false;
    public Vector includePaths = new Vector();
    public Hashtable definedSymbols = new Hashtable();
    public boolean cppModule = false;
    public boolean versionRequest = false;
    public float corbaLevel = 2.2f;
    public boolean noWarn = false;
    public boolean scannerDebugFlag = false;
    public boolean tokenDebugFlag = false;

    protected void parseOtherArgs(String[] stringArray, Properties properties) throws InvalidArgument {
        if (stringArray.length > 0) {
            throw new InvalidArgument(stringArray[0]);
        }
    }

    protected void setDebugFlags(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                Field field = this.getClass().getField(string2 + "DebugFlag");
                int n2 = field.getModifiers();
                if (!Modifier.isPublic(n2) || Modifier.isStatic(n2) || field.getType() != Boolean.TYPE) continue;
                field.setBoolean(this, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void parseArgs(String[] stringArray) throws InvalidArgument {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        try {
            n2 = 0;
            while (n2 < stringArray.length - 1) {
                if (stringArray[n2].charAt(0) != '-' && stringArray[n2].charAt(0) != '/') {
                    throw new InvalidArgument(stringArray[n2]);
                }
                object2 = stringArray[n2].substring(1).toLowerCase();
                if (((String)object2).equals("i")) {
                    this.includePaths.addElement(stringArray[++n2]);
                } else if (((String)object2).startsWith("i")) {
                    this.includePaths.addElement(stringArray[n2].substring(2));
                } else if (((String)object2).equals("v") || ((String)object2).equals("verbose")) {
                    this.verbose = true;
                } else if (((String)object2).equals("d")) {
                    this.definedSymbols.put(stringArray[++n2], "");
                } else if (((String)object2).equals("debug")) {
                    this.setDebugFlags(stringArray[++n2]);
                } else if (((String)object2).startsWith("d")) {
                    this.definedSymbols.put(stringArray[n2].substring(2), "");
                } else if (((String)object2).equals("emitall")) {
                    this.emitAll = true;
                } else if (((String)object2).equals("keep")) {
                    this.keepOldFiles = true;
                } else if (((String)object2).equals("nowarn")) {
                    this.noWarn = true;
                } else if (((String)object2).equals("trace")) {
                    Runtime.getRuntime().traceMethodCalls(true);
                } else if (((String)object2).equals("cppmodule")) {
                    this.cppModule = true;
                } else if (((String)object2).equals("version")) {
                    this.versionRequest = true;
                } else if (((String)object2).equals("corba")) {
                    if (n2 + 1 >= stringArray.length) {
                        throw new InvalidArgument(stringArray[n2]);
                    }
                    if (((String)(object = stringArray[++n2])).charAt(0) == '-') {
                        throw new InvalidArgument(stringArray[n2 - 1]);
                    }
                    try {
                        this.corbaLevel = new Float((String)object).floatValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidArgument(stringArray[n2]);
                    }
                } else {
                    vector.addElement(stringArray[n2]);
                    ++n2;
                    while (n2 < stringArray.length - 1 && stringArray[n2].charAt(0) != '-' && stringArray[n2].charAt(0) != '/') {
                        vector.addElement(stringArray[n2++]);
                    }
                    --n2;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidArgument(stringArray[stringArray.length - 1]);
        }
        if (n2 == stringArray.length - 1) {
            if (stringArray[n2].toLowerCase().equals("-version")) {
                this.versionRequest = true;
            } else {
                this.file = stringArray[n2];
            }
        } else {
            throw new InvalidArgument();
        }
        object2 = new Properties();
        try {
            object = FileLocator.locateFileInClassPath("idl.config");
            ((Properties)object2).load((InputStream)object);
            this.addIncludePaths((Properties)object2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (vector.size() > 0) {
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
        } else {
            object = new String[]{};
        }
        this.parseOtherArgs((String[])object, (Properties)object2);
    }

    private void addIncludePaths(Properties properties) {
        String string = properties.getProperty("includes");
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            int n2 = -string2.length();
            do {
                if ((n2 = (string = string.substring(n2 + string2.length())).indexOf(string2)) < 0) {
                    n2 = string.length();
                }
                this.includePaths.addElement(string.substring(0, n2));
            } while (n2 != string.length());
        }
    }
}

