/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class KunststoffTextAreaUI
extends BasicTextAreaUI {
    protected JComponent myComponent;

    public KunststoffTextAreaUI(JComponent c2) {
        this.myComponent = c2;
    }

    public static ComponentUI createUI(JComponent c2) {
        return new KunststoffTextAreaUI(c2);
    }

    protected void paintBackground(Graphics g2) {
        ColorUIResource colorShadow;
        super.paintBackground(g2);
        Rectangle editorRect = this.getVisibleEditorRect();
        ColorUIResource colorReflection = KunststoffLookAndFeel.getTextComponentGradientColorReflection();
        if (colorReflection != null) {
            Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
            Rectangle rect = new Rectangle(editorRect.x, editorRect.y, editorRect.width, editorRect.height / 2);
            KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rect, true);
        }
        if ((colorShadow = KunststoffLookAndFeel.getTextComponentGradientColorShadow()) != null) {
            Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
            Rectangle rect = new Rectangle(editorRect.x, editorRect.y + editorRect.height / 2, editorRect.width, editorRect.height / 2);
            KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rect, true);
        }
    }
}

