/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;

class FastGradientPaintContext
implements PaintContext {
    private static WeakHashMap gradientCache = new WeakHashMap();
    private static LinkedList recentInfos = new LinkedList();
    GradientInfo info = new GradientInfo();
    int parallelDevicePos;
    Gradient gradient;

    FastGradientPaintContext(ColorModel cm, Rectangle r2, int sc, int ec, boolean ver) {
        Object o2;
        this.info.model = ((sc & ec) >> 24 & 0xFF) != 255 ? ColorModel.getRGBdefault() : cm;
        this.info.startColor = sc;
        this.info.endColor = ec;
        this.info.isVertical = ver;
        if (this.info.isVertical) {
            this.parallelDevicePos = r2.y;
            this.info.parallelLength = r2.height;
        } else {
            this.parallelDevicePos = r2.x;
            this.info.parallelLength = r2.width;
        }
        recentInfos.remove(this.info);
        recentInfos.add(0, this.info);
        if (recentInfos.size() > 16) {
            recentInfos.removeLast();
        }
        if ((o2 = gradientCache.get(this.info)) != null) {
            o2 = ((WeakReference)o2).get();
        }
        if (o2 != null) {
            this.gradient = (Gradient)o2;
        } else {
            this.gradient = new Gradient(this.info);
            gradientCache.put(this.info, new WeakReference<Gradient>(this.gradient));
        }
    }

    public void dispose() {
        this.gradient.dispose();
    }

    public ColorModel getColorModel() {
        return this.info.model;
    }

    public synchronized Raster getRaster(int x2, int y2, int w2, int h2) {
        if (this.info.isVertical) {
            return this.gradient.getRaster(y2 - this.parallelDevicePos, w2, h2);
        }
        return this.gradient.getRaster(x2 - this.parallelDevicePos, h2, w2);
    }

    private class Gradient {
        GradientInfo info;
        int perpendicularLength = 0;
        WritableRaster raster;
        HashMap childRasterCache;

        Gradient(GradientInfo i2) {
            this.info = i2;
        }

        private Raster getRaster(int parallelPos, int perpendicularLength, int parallelLength) {
            Integer key;
            Object o2;
            if (this.raster == null || this.perpendicularLength < perpendicularLength) {
                this.createRaster(perpendicularLength);
            }
            if ((o2 = this.childRasterCache.get(key = new Integer(parallelPos))) != null) {
                return (Raster)o2;
            }
            Raster r2 = this.info.isVertical ? this.raster.createChild(0, parallelPos, this.perpendicularLength, this.info.parallelLength - parallelPos, 0, 0, null) : this.raster.createChild(parallelPos, 0, this.info.parallelLength - parallelPos, this.perpendicularLength, 0, 0, null);
            this.childRasterCache.put(key, r2);
            return r2;
        }

        public void dispose() {
        }

        private void createRaster(int perpendicularLength) {
            int gradientWidth;
            int gradientHeight;
            if (this.info.isVertical) {
                gradientHeight = this.info.parallelLength;
                gradientWidth = this.perpendicularLength = perpendicularLength;
            } else {
                gradientWidth = this.info.parallelLength;
                gradientHeight = this.perpendicularLength = perpendicularLength;
            }
            int sa = this.info.startColor >> 24 & 0xFF;
            int sr = this.info.startColor >> 16 & 0xFF;
            int sg = this.info.startColor >> 8 & 0xFF;
            int sb = this.info.startColor & 0xFF;
            int da = (this.info.endColor >> 24 & 0xFF) - sa;
            int dr = (this.info.endColor >> 16 & 0xFF) - sr;
            int dg = (this.info.endColor >> 8 & 0xFF) - sg;
            int db2 = (this.info.endColor & 0xFF) - sb;
            this.raster = this.info.model.createCompatibleWritableRaster(gradientWidth, gradientHeight);
            Object c2 = null;
            int pl = this.info.parallelLength;
            int i2 = 0;
            while (i2 < pl) {
                c2 = this.info.model.getDataElements(sa + i2 * da / pl << 24 | sr + i2 * dr / pl << 16 | sg + i2 * dg / pl << 8 | sb + i2 * db2 / pl, c2);
                int j2 = 0;
                while (j2 < perpendicularLength) {
                    if (this.info.isVertical) {
                        this.raster.setDataElements(j2, i2, c2);
                    } else {
                        this.raster.setDataElements(i2, j2, c2);
                    }
                    ++j2;
                }
                ++i2;
            }
            this.childRasterCache = new HashMap();
        }
    }

    private class GradientInfo {
        ColorModel model;
        int parallelLength;
        int startColor;
        int endColor;
        boolean isVertical;

        private GradientInfo() {
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof GradientInfo)) {
                return false;
            }
            GradientInfo gi = (GradientInfo)o2;
            return gi.model.equals(this.model) && gi.parallelLength == this.parallelLength && gi.startColor == this.startColor && gi.endColor == this.endColor && gi.isVertical == this.isVertical;
        }

        public int hashCode() {
            return this.parallelLength;
        }

        public String toString() {
            return "Direction:" + (this.isVertical ? "ver" : "hor") + ", Length: " + Integer.toString(this.parallelLength) + ", Color1: " + Integer.toString(this.startColor, 16) + ", Color2: " + Integer.toString(this.endColor, 16);
        }
    }
}

