/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Dimension;
import java.awt.Label;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LabelView
extends Label
implements SingletonModelView,
SingletonModelListener,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private boolean readOnly;
    private boolean postOnFocusLost = true;
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel sm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = sm;
        WritableSingletonModel writableSingletonModel = this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)sm : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener l2) {
        this.modelMulticaster.add(l2);
    }

    public void removeModelListener(SingletonModelListener l2) {
        this.modelMulticaster.remove(l2);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public void setText(String text) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            this.writeModel.set(text);
        }
    }

    protected void updateText() {
        if (this.model != null) {
            Object o2 = this.model.get();
            super.setText(o2 != null ? o2.toString() : "");
        }
    }

    protected void postText() {
        if (this.writeModel != null && this.writeModel.canSet(true)) {
            String text = super.getText();
            this.writeModel.set(text);
        }
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        this.updateText();
    }

    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        if (d2.width < 2) {
            d2.width = 100;
        }
        return d2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof SingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

