/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.util.ActionMulticaster;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.SerializableImage;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class BeanPanel
extends JComponent
implements Serializable {
    private static final long serialVersionUID = 200L;
    protected transient WindowListener winListener = new WindowAdapter(){

        public void windowActivated(WindowEvent e2) {
            BeanPanel.this.windowActiveChanged(true);
        }

        public void windowDeactivated(WindowEvent e2) {
            BeanPanel.this.windowActiveChanged(false);
        }
    };
    protected transient ActionMulticaster actionMulticaster;
    protected transient Image texture;
    protected boolean focusAware = true;
    protected int focusState;
    protected transient boolean foundParentWindow = false;
    transient Rectangle _bounds = new Rectangle();
    static boolean is1dot3;
    static /* synthetic */ Class class$javax$swing$JComponent;

    public BeanPanel() {
        this.enableEvents(60L);
        super.setLayout(new FlowLayout());
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public BeanPanel(LayoutManager layout) {
        this.enableEvents(60L);
        super.setLayout(layout);
        super.setDoubleBuffered(true);
        super.setOpaque(true);
    }

    public synchronized void addActionListener(ActionListener l2) {
        if (this.actionMulticaster == null) {
            this.actionMulticaster = new ActionMulticaster();
        }
        this.actionMulticaster.add(l2);
    }

    public synchronized void removeActionListener(ActionListener l2) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.remove(l2);
        }
    }

    public void setTexture(Image texture) {
        this.texture = texture;
        if (texture != null) {
            ImageLoader.waitForImage(this, texture);
        }
        this.repaint();
    }

    public Image getTexture() {
        return this.texture;
    }

    public void setOpaque(boolean opaque) {
        super.setOpaque(opaque);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean isOpaque() {
        return this.texture != null ? true : super.isOpaque();
    }

    public void setBackground(Color c2) {
        super.setBackground(c2);
        this.repaint();
    }

    public void setForeground(Color c2) {
        super.setForeground(c2);
        this.repaint();
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.isOpaque()) {
            Rectangle clip = g2.getClipBounds();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, g2, clip.x, clip.y, clip.width, clip.height);
            } else {
                g2.setColor(this.getBackground());
                g2.fillRect(clip.x, clip.y, clip.width, clip.height);
            }
        }
    }

    protected void processEvent(AWTEvent e2) {
        if (e2 instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e2);
        } else {
            super.processEvent(e2);
        }
    }

    protected void processActionEvent(ActionEvent e2) {
        if (this.actionMulticaster != null) {
            this.actionMulticaster.dispatch(e2);
        }
    }

    protected void processKeyEvent(KeyEvent e2) {
        if (!this.isEnabled()) {
            return;
        }
        super.processKeyEvent(e2);
        if (!e2.isConsumed()) {
            switch (e2.getID()) {
                case 401: {
                    this.processKeyPressed(e2);
                    break;
                }
                case 400: {
                    this.processKeyTyped(e2);
                    break;
                }
                case 402: {
                    this.processKeyReleased(e2);
                }
            }
        }
    }

    protected void processKeyPressed(KeyEvent e2) {
    }

    protected void processKeyTyped(KeyEvent e2) {
    }

    protected void processKeyReleased(KeyEvent e2) {
    }

    protected void processMouseEvent(MouseEvent e2) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseEvent(e2);
        if (!e2.isConsumed()) {
            switch (e2.getID()) {
                case 501: {
                    this.processMousePressed(e2);
                    break;
                }
                case 502: {
                    this.processMouseReleased(e2);
                    break;
                }
                case 500: {
                    this.processMouseClicked(e2);
                    break;
                }
                case 504: {
                    this.processMouseEntered(e2);
                    break;
                }
                case 505: {
                    this.processMouseExited(e2);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e2) {
        if (!this.isEnabled()) {
            return;
        }
        super.processMouseMotionEvent(e2);
        if (!e2.isConsumed()) {
            switch (e2.getID()) {
                case 503: {
                    this.processMouseMoved(e2);
                    break;
                }
                case 506: {
                    this.processMouseDragged(e2);
                }
            }
        }
    }

    protected void processMousePressed(MouseEvent e2) {
        if (e2.getClickCount() == 1 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    protected void processMouseReleased(MouseEvent e2) {
    }

    protected void processMouseClicked(MouseEvent e2) {
    }

    protected void processMouseEntered(MouseEvent e2) {
    }

    protected void processMouseExited(MouseEvent e2) {
    }

    protected void processMouseMoved(MouseEvent e2) {
    }

    protected void processMouseDragged(MouseEvent e2) {
    }

    protected void setFocusAware(boolean aware) {
        this.focusAware = aware;
    }

    protected boolean isFocusAware() {
        return this.focusAware;
    }

    public boolean isFocusTraversable() {
        return this.focusAware;
    }

    protected void processFocusEvent(FocusEvent e2) {
        if (this.focusAware) {
            switch (e2.getID()) {
                case 1004: {
                    this.focusState |= 2;
                    break;
                }
                case 1005: {
                    this.focusState &= 0xFFFFFFFD;
                }
            }
        }
        super.processFocusEvent(e2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void windowActiveChanged(boolean active) {
        this.focusState = active ? (this.focusState &= 0xFFFFFFDF) : (this.focusState |= 0x20);
    }

    public void addNotify() {
        super.addNotify();
        this.findParentWindow();
    }

    public void removeNotify() {
        this.dropParentWindow();
        super.removeNotify();
    }

    protected void findParentWindow() {
        Container c2;
        if (this.foundParentWindow) {
            return;
        }
        for (c2 = this.getParent(); c2 != null && !(c2 instanceof Window); c2 = c2.getParent()) {
        }
        if (c2 instanceof Window) {
            ((Window)c2).addWindowListener(this.winListener);
            this.foundParentWindow = true;
        }
    }

    protected void dropParentWindow() {
        Container c2;
        for (c2 = this.getParent(); c2 != null && !(c2 instanceof Window); c2 = c2.getParent()) {
        }
        if (c2 instanceof Window) {
            ((Window)c2).removeWindowListener(this.winListener);
        }
        this.foundParentWindow = false;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        if (this.texture != null) {
            s2.writeObject(SerializableImage.create(this.texture));
        } else {
            s2.writeObject(null);
        }
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof SerializableImage) {
            this.texture = ((SerializableImage)data).getImage();
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        serialVersionUID = 200L;
        is1dot3 = true;
        try {
            Method method = (class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BeanPanel.class$("javax.swing.JComponent")) : class$javax$swing$JComponent).getMethod("getInputVerifier", null);
            is1dot3 = method != null;
        }
        catch (NoSuchMethodException e2) {
            is1dot3 = false;
        }
    }
}

