/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.jbcl.util.Res;
import java.awt.Color;
import java.io.Serializable;

public class ColorWheel
implements Serializable {
    public static final int RED_TO_YELLOW = 1;
    public static final int YELLOW_TO_GREEN = 2;
    public static final int GREEN_TO_CYAN = 3;
    public static final int CYAN_TO_BLUE = 4;
    public static final int BLUE_TO_MAGENTA = 5;
    public static final int MAGENTA_TO_RED = 6;
    private int increment = 50;
    private int cycle = 1;
    private Color current = Color.red;

    public ColorWheel() {
    }

    public ColorWheel(Color startColor) {
        this.current = startColor;
    }

    public ColorWheel(Color startColor, int startCycle) {
        this.current = startColor;
        this.cycle = startCycle;
    }

    public ColorWheel(Color startColor, int startCycle, int increment) {
        this.current = startColor;
        this.cycle = startCycle;
        this.increment = increment;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int newIncrement) {
        if (newIncrement < 1 || newIncrement > 255) {
            throw new IllegalArgumentException(Res._NotInRange);
        }
        this.increment = newIncrement;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setCycle(int newCycle) {
        if (newCycle < 1 || newCycle > 6) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(Res._InvalidCycle)).concat(String.valueOf(String.valueOf(newCycle))));
        }
        this.cycle = newCycle;
    }

    public Color getColor() {
        return this.current;
    }

    public void setColor(Color newColor) {
        if (newColor != null) {
            this.current = newColor;
        }
    }

    public Color next() {
        return this.next(this.current);
    }

    public Color next(Color color) {
        int r2 = color.getRed();
        int g2 = color.getGreen();
        int b2 = color.getBlue();
        switch (this.cycle) {
            case 1: {
                if ((g2 += this.increment) <= 255) break;
                g2 = 255;
                this.cycle = 2;
                break;
            }
            case 2: {
                if ((r2 -= this.increment) >= 0) break;
                r2 = 0;
                this.cycle = 3;
                break;
            }
            case 3: {
                if ((b2 += this.increment) <= 255) break;
                b2 = 255;
                this.cycle = 4;
                break;
            }
            case 4: {
                if ((g2 -= this.increment) >= 0) break;
                g2 = 0;
                this.cycle = 5;
                break;
            }
            case 5: {
                if ((r2 += this.increment) <= 255) break;
                r2 = 255;
                this.cycle = 6;
                break;
            }
            case 6: {
                if ((b2 -= this.increment) >= 0) break;
                b2 = 0;
                this.cycle = 1;
                break;
            }
            default: {
                this.cycle = 1;
            }
        }
        this.current = new Color(r2, g2, b2);
        return this.current;
    }

    static {
        RED_TO_YELLOW = 1;
        YELLOW_TO_GREEN = 2;
        GREEN_TO_CYAN = 3;
        CYAN_TO_BLUE = 4;
        BLUE_TO_MAGENTA = 5;
        MAGENTA_TO_RED = 6;
    }
}

