/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.ModelEvent;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class VectorModelEvent
extends ModelEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    public static final int CONTENT_CHANGED = 1;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int ITEM_CHANGED = 17;
    public static final int ITEM_TOUCHED = 33;
    public static final int ITEM_ADDED = 18;
    public static final int ITEM_REMOVED = 34;
    private transient VectorModel model;
    private int change;
    private int location;

    public VectorModelEvent(VectorModel model, int change) {
        super(model, change);
        this.model = model;
        this.change = change;
    }

    public VectorModelEvent(VectorModel model, int change, int location) {
        this(model, change);
        this.location = location;
    }

    public VectorModel getModel() {
        return this.model;
    }

    public int getChange() {
        return this.change;
    }

    public int getLocation() {
        return this.location;
    }

    public void dispatch(EventListener listener) {
        switch (this.getID()) {
            case 1: {
                ((VectorModelListener)listener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((VectorModelListener)listener).modelStructureChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        String changeString;
        switch (this.change) {
            case 1: {
                changeString = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                changeString = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                changeString = "ITEM_CHANGED";
                break;
            }
            case 33: {
                changeString = "ITEM_TOUCHED";
                break;
            }
            case 18: {
                changeString = "ITEM_ADDED";
                break;
            }
            case 34: {
                changeString = "ITEM_REMOVED";
                break;
            }
            default: {
                changeString = "<INVALID>";
            }
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(super.paramString()))).append(",model=").append(this.model).append(",change=").append(changeString).append(",location=").append(this.location)));
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof VectorModel) {
            this.model = (VectorModel)data;
        }
    }

    static {
        serialVersionUID = 200L;
        CONTENT_CHANGED = 1;
        STRUCTURE_CHANGED = 2;
        ITEM_CHANGED = 17;
        ITEM_TOUCHED = 33;
        ITEM_ADDED = 18;
        ITEM_REMOVED = 34;
    }
}

