/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class RowMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private int cellRow = -1;
    private int columns;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public RowMatrixSelection() {
    }

    public RowMatrixSelection(int maxColumns) {
        this.columns = maxColumns;
    }

    public RowMatrixSelection(int maxColumns, int row) {
        this.columns = maxColumns;
        this.cellRow = row;
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public void setMaxColumns(int maxColumns) {
        this.columns = maxColumns;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public boolean contains(MatrixLocation location) {
        return this.cellRow != -1 ? location.row == this.cellRow : false;
    }

    public boolean contains(int row, int column) {
        return this.cellRow != -1 ? row == this.cellRow : false;
    }

    public int getCount() {
        return this.cellRow != -1 ? this.columns : 0;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.cellRow != -1 ? this.columns : 0];
        if (this.cellRow != -1) {
            for (int i2 = 0; i2 < contents.length; ++i2) {
                contents[i2] = new MatrixLocation(this.cellRow, i2);
            }
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void set(MatrixLocation[] locations) {
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        if (location.row != this.cellRow) {
            this.cellRow = location.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int row, int column) {
        if (row != this.cellRow) {
            this.cellRow = row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        if (locations.length > 0 && locations[0].row != this.cellRow) {
            this.cellRow = locations[0].row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        if (end.row != this.cellRow) {
            this.cellRow = end.row;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cellRow != endRow) {
            this.cellRow = endRow;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        if (this.cellRow != -1 && location.row == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(int row, int column) {
        if (this.cellRow != -1 && row == this.cellRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        if (this.cellRow != -1) {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                if (locations[i2].row != this.cellRow) continue;
                this.cellRow = -1;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.cellRow != -1 && this.cellRow >= beginRow && this.cellRow <= endRow) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellRow != -1) {
            this.cellRow = -1;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(e2);
        }
    }
}

