/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.Vector;

public class MultiColumnMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private Vector cellColumns = new Vector();
    private int rows;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public MultiColumnMatrixSelection() {
    }

    public MultiColumnMatrixSelection(int maxRows) {
        this.rows = maxRows;
    }

    public MultiColumnMatrixSelection(int maxRows, int[] columns) {
        this.rows = maxRows;
        for (int i2 = 0; i2 < columns.length; ++i2) {
            Integer integer = new Integer(columns[i2]);
            if (this.cellColumns.contains(integer)) continue;
            this.cellColumns.addElement(integer);
        }
    }

    public MultiColumnMatrixSelection(int maxRows, MatrixLocation[] selection) {
        this.rows = maxRows;
        for (int i2 = 0; i2 < selection.length; ++i2) {
            Integer integer = new Integer(selection[i2].column);
            if (this.cellColumns.contains(integer)) continue;
            this.cellColumns.addElement(integer);
        }
    }

    public int getMaxRows() {
        return this.rows;
    }

    public void setMaxRows(int maxRows) {
        this.rows = maxRows;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public boolean contains(MatrixLocation location) {
        return this.contains(location.row, location.column);
    }

    public boolean contains(int row, int column) {
        Integer integer = new Integer(column);
        return this.cellColumns.contains(integer);
    }

    public int getCount() {
        return this.cellColumns.size() * this.rows;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.cellColumns.size() * this.rows];
        int i2 = 0;
        for (int c2 = 0; c2 < this.cellColumns.size(); ++c2) {
            for (int r2 = 0; r2 < this.rows; ++r2) {
                contents[i2++] = new MatrixLocation(r2, (Integer)this.cellColumns.elementAt(c2));
            }
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void set(MatrixLocation[] locations) {
        this.cellColumns.removeAllElements();
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        this.add(location.row, location.column);
    }

    public void add(int row, int column) {
        Integer integer = new Integer(column);
        if (!this.cellColumns.contains(integer)) {
            this.cellColumns.addElement(integer);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            Integer integer = new Integer(locations[i2].column);
            if (this.cellColumns.contains(integer)) continue;
            changed = true;
            this.cellColumns.addElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        this.addRange(begin.row, begin.column, end.row, end.column);
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loCol = beginColumn < endColumn ? beginColumn : endColumn;
        int hiCol = beginColumn > endColumn ? beginColumn : endColumn;
        boolean changed = false;
        for (int c2 = loCol; c2 <= hiCol; ++c2) {
            Integer integer = new Integer(c2);
            if (this.cellColumns.contains(integer)) continue;
            changed = true;
            this.cellColumns.addElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        this.remove(location.row, location.column);
    }

    public void remove(int row, int column) {
        Integer integer = new Integer(column);
        if (this.cellColumns.contains(integer)) {
            this.cellColumns.removeElement(integer);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            Integer integer = new Integer(locations[i2].column);
            if (!this.cellColumns.contains(integer)) continue;
            changed = true;
            this.cellColumns.removeElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loCol = beginColumn < endColumn ? beginColumn : endColumn;
        int hiCol = beginColumn > endColumn ? beginColumn : endColumn;
        boolean changed = false;
        for (int c2 = loCol; c2 <= hiCol; ++c2) {
            Integer integer = new Integer(c2);
            if (!this.cellColumns.contains(integer)) continue;
            changed = true;
            this.cellColumns.removeElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellColumns.size() > 0) {
            this.cellColumns.removeAllElements();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(e2);
        }
    }
}

