/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.Res;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GraphModelSearch
implements Serializable {
    protected transient GraphModel model;
    protected boolean depthFirstSearch = false;
    protected boolean fullSearch = true;

    public GraphModelSearch() {
    }

    public GraphModelSearch(GraphModel model) {
        this.model = model;
    }

    public GraphModelSearch(GraphModel model, boolean depthFirstSearch) {
        this(model);
        this.depthFirstSearch = depthFirstSearch;
    }

    public GraphModelSearch(GraphModel model, boolean depthFirstSearch, boolean fullSearch) {
        this(model, depthFirstSearch);
        this.fullSearch = fullSearch;
    }

    public void setModel(GraphModel model) {
        this.model = model;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setDepthFirstSearch(boolean depthFirstSearch) {
        this.depthFirstSearch = depthFirstSearch;
    }

    public boolean isDepthFirstSearch() {
        return this.depthFirstSearch;
    }

    public void setFullSearch(boolean fullSearch) {
        this.fullSearch = fullSearch;
    }

    public boolean isFullSearch() {
        return this.fullSearch;
    }

    public GraphLocation search(Object data) {
        this.checkModel();
        if (data instanceof GraphLocation) {
            return (GraphLocation)data;
        }
        return this.search(this.model.getRoot(), data);
    }

    public GraphLocation search(GraphLocation node, Object data) {
        GraphLocation found;
        this.checkModel();
        if (this.checkMatch(this.model.get(node), data)) {
            return node;
        }
        int hasChildren = node.hasChildren();
        if (hasChildren == 0 || !this.fullSearch && hasChildren == -1) {
            return null;
        }
        GraphLocation[] children = node.getChildren();
        GraphLocation graphLocation = found = this.depthFirstSearch ? null : this.scanNodes(children, data);
        if (found != null) {
            return found;
        }
        for (int i2 = 0; i2 < children.length; ++i2) {
            found = this.search(children[i2], data);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public GraphLocation pathSearch(Object[] data) {
        this.checkModel();
        if (data != null && data.length > 0) {
            return this.pathSearch(this.model.getRoot(), data);
        }
        return null;
    }

    public GraphLocation pathSearch(GraphLocation node, Object[] data) {
        this.checkModel();
        GraphLocation currentNode = node;
        for (int i2 = 0; i2 < data.length; ++i2) {
            GraphLocation found = this.search(currentNode, data[i2]);
            if (found == null) {
                return null;
            }
            currentNode = found;
        }
        return currentNode;
    }

    public GraphLocation partialPathSearch(Object[] data) {
        this.checkModel();
        if (data != null && data.length > 0) {
            return this.partialPathSearch(this.model.getRoot(), data);
        }
        return null;
    }

    public GraphLocation partialPathSearch(GraphLocation node, Object[] data) {
        this.checkModel();
        GraphLocation currentNode = node;
        for (int i2 = 0; i2 < data.length; ++i2) {
            GraphLocation found = this.search(currentNode, data[i2]);
            if (found == null) {
                return currentNode;
            }
            currentNode = found;
        }
        return currentNode;
    }

    public GraphLocation exactPathSearch(Object[] data) {
        this.checkModel();
        if (data != null && data.length > 0) {
            return this.exactPathSearch(this.model.getRoot(), data);
        }
        return null;
    }

    public GraphLocation exactPathSearch(GraphLocation node, Object[] data) {
        this.checkModel();
        if (data.length < 1 || !this.checkMatch(this.model.get(node), data[0])) {
            return null;
        }
        GraphLocation currentNode = node;
        for (int i2 = 1; i2 < data.length; ++i2) {
            int hasChildren = currentNode.hasChildren();
            if (hasChildren == 0 || !this.fullSearch && hasChildren == -1) {
                return null;
            }
            GraphLocation[] children = currentNode.getChildren();
            GraphLocation found = this.scanNodes(children, data[i2]);
            if (found == null) {
                return null;
            }
            currentNode = found;
        }
        return currentNode;
    }

    protected void checkModel() {
        if (this.model == null) {
            throw new IllegalStateException(Res._NoModelSet);
        }
    }

    protected boolean checkMatch(Object first, Object second) {
        return first == second || first != null && first.equals(second);
    }

    protected GraphLocation scanNodes(GraphLocation[] nodes, Object data) {
        this.checkModel();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            if (!this.checkMatch(this.model.get(nodes[i2]), data)) continue;
            return nodes[i2];
        }
        return null;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof GraphModel) {
            this.model = (GraphModel)data;
        }
    }
}

