/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;

public class CrossMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private MatrixLocation cell;
    private int rows;
    private int columns;
    private boolean valid;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public CrossMatrixSelection() {
    }

    public CrossMatrixSelection(int maxRows, int maxColumns) {
        this.rows = maxRows;
        this.columns = maxColumns;
    }

    public CrossMatrixSelection(int maxRows, int maxColumns, MatrixLocation focus) {
        this(maxRows, maxColumns);
        this.cell = focus;
        this.checkValid();
    }

    public int getMaxRows() {
        return this.rows;
    }

    public void setMaxRows(int maxRows) {
        this.rows = maxRows;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public void setMaxColumns(int maxColumns) {
        this.columns = maxColumns;
        this.checkValid();
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    private void checkValid() {
        this.valid = this.rows > 0 && this.columns > 0 && this.cell != null;
    }

    public boolean contains(MatrixLocation location) {
        return this.valid ? location.row == this.cell.row || location.column == this.cell.column : false;
    }

    public boolean contains(int row, int column) {
        return this.valid ? row == this.cell.row || column == this.cell.column : false;
    }

    public int getCount() {
        return this.valid ? this.rows + this.columns - 1 : 0;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.valid ? this.rows + this.columns - 1 : 0];
        if (this.valid) {
            int i2 = 0;
            for (int r2 = 0; r2 < this.rows; ++r2) {
                contents[i2++] = new MatrixLocation(r2, this.cell.column);
            }
            for (int c2 = 0; c2 < this.columns; ++c2) {
                if (c2 == this.cell.column) continue;
                contents[i2++] = new MatrixLocation(this.cell.row, c2);
            }
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void set(MatrixLocation[] locations) {
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        if (location != null && !location.equals(this.cell)) {
            this.cell = location;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(int row, int column) {
        if (row != this.cell.row || column != this.cell.column) {
            this.cell = new MatrixLocation(row, column);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        if (locations.length > 0 && !locations[0].equals(this.cell)) {
            this.cell = locations[0];
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        if (end != null && !end.equals(this.cell)) {
            this.cell = end;
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (endRow != this.cell.row || endColumn != this.cell.column) {
            this.cell = new MatrixLocation(endRow, endColumn);
            this.checkValid();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        if (this.valid && location != null && location.equals(this.cell)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(int row, int column) {
        if (this.valid && row == this.cell.row && column == this.cell.column) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        if (this.valid && locations.length > 0) {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                if (locations[i2] == null || !locations[i2].equals(this.cell)) continue;
                this.cell = null;
                this.valid = false;
                this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
                return;
            }
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        if (this.valid && (this.cell.row >= beginRow && this.cell.row <= endRow || this.cell.column >= beginColumn && this.cell.column <= endColumn)) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.valid) {
            this.cell = null;
            this.valid = false;
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(e2);
        }
    }
}

