/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.WritableVectorModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class BasicVectorContainer
implements WritableVectorModel,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient Vector array;
    private boolean variableSize = true;
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public BasicVectorContainer() {
        this.array = new Vector();
    }

    public BasicVectorContainer(int size) {
        this.array = new Vector(size);
    }

    public BasicVectorContainer(int size, Object object) {
        this.array = new Vector(size);
        for (int i2 = 0; i2 < size; ++i2) {
            this.array.addElement(object);
        }
    }

    public BasicVectorContainer(Object[] newArray) {
        this.array = new Vector();
        Object[] objectArray = newArray;
        synchronized (objectArray) {
            int count = newArray.length;
            for (int i2 = 0; i2 < count; ++i2) {
                this.array.addElement(newArray[i2]);
            }
        }
    }

    public Object[] getItems() {
        Object[] items = new Object[this.array.size()];
        this.array.copyInto(items);
        return items;
    }

    public void setItems(Object[] newItems) {
        this.array = new Vector();
        Object[] objectArray = newItems;
        synchronized (objectArray) {
            int count = newItems.length;
            for (int i2 = 0; i2 < count; ++i2) {
                this.array.addElement(newItems[i2]);
            }
        }
        this.processModelEvent(new VectorModelEvent(this, 2));
    }

    public Object get(int index) {
        if (index >= 0 && this.array.size() > index) {
            return this.array.elementAt(index);
        }
        return null;
    }

    public int getCount() {
        return this.array.size();
    }

    public int find(Object data) {
        return this.array.indexOf(data);
    }

    public void setCount(int count) {
        int size = this.array.size();
        if (!this.variableSize || count == size) {
            return;
        }
        if (count > size) {
            for (int i2 = size; i2 < count; ++i2) {
                this.array.addElement(null);
            }
        } else {
            for (int i3 = size; i3 > count; --i3) {
                this.array.removeElementAt(i3 - 1);
            }
        }
    }

    public void addModelListener(VectorModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelListener(VectorModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public boolean canSet(int index, boolean startEdit) {
        return index < this.array.size();
    }

    public void set(int index, Object object) {
        this.array.setElementAt(object, index);
        this.processModelEvent(new VectorModelEvent(this, 17, index));
    }

    public void touched(int index) {
        if (index < this.array.size()) {
            this.processModelEvent(new VectorModelEvent(this, 33, index));
        }
    }

    public boolean isVariableSize() {
        return this.variableSize;
    }

    public void setVariableSize(boolean variable) {
        this.variableSize = variable;
    }

    public void addItem(Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.addElement(object);
        this.processModelEvent(new VectorModelEvent(this, 18, this.array.size()));
    }

    public void addItem(int aheadOf, Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.insertElementAt(object, aheadOf);
        this.processModelEvent(new VectorModelEvent(this, 18, aheadOf));
    }

    public void remove(int index) {
        if (!this.variableSize) {
            return;
        }
        this.array.removeElementAt(index);
        this.processModelEvent(new VectorModelEvent(this, 34, index));
    }

    public void removeAll() {
        if (!this.variableSize) {
            return;
        }
        if (this.array.size() > 0) {
            this.array.removeAllElements();
            this.processModelEvent(new VectorModelEvent(this, 2));
        }
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent(new VectorModelEvent(this, 2));
            }
        }
    }

    protected void processModelEvent(VectorModelEvent e2) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(e2);
        }
    }

    public Enumeration begin() {
        return this.array.elements();
    }

    public Vector getVector() {
        return this.array;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Vector newArray = new Vector();
        for (int i2 = 0; i2 < this.array.size(); ++i2) {
            if (!(this.array.elementAt(i2) instanceof Serializable)) continue;
            newArray.addElement(this.array.elementAt(i2));
        }
        s2.writeObject(newArray);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        this.array = (Vector)s2.readObject();
    }

    static {
        serialVersionUID = 200L;
    }
}

