/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnVariant;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.RowFilterListener;
import com.borland.dx.dataset.Variant;
import com.borland.jbcl.control.GridControl;
import com.borland.jbcl.control.LookupDialog;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.TooManyListenersException;

public class PopupPickListItemEditor
implements ItemEditor,
Serializable {
    String currentColumnName;
    String[] sourceColumns;
    String[] targetColumns;
    Column[] pickListColumns;
    String[] displayColumns;
    DataSetView pickListDataSet;
    DataSet targetDataSet;
    DataRow locateRow;
    int[] columnOriginalState;
    int[] columnDialogState;
    Variant value = new Variant();
    GridControl gridControl = new GridControl();
    LookupDialog lookupDialog;
    String windowTitle = "";
    boolean allowSearch = true;
    boolean alwaysCenter = false;
    boolean displayOKCancel = false;
    transient RowFilterListener listener;

    public final void setTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public final String getTitle() {
        return this.windowTitle;
    }

    public final void setAllowSearch(boolean allowSearch) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setAllowSearch(allowSearch);
        }
        this.allowSearch = allowSearch;
    }

    public final boolean isAllowSearch() {
        return this.allowSearch;
    }

    public final void setAlwaysCenter(boolean alwaysCenter) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setAlwaysCenter(alwaysCenter);
        }
        this.alwaysCenter = alwaysCenter;
    }

    public final boolean isAlwaysCenter() {
        return this.alwaysCenter;
    }

    public final void addRowFilterListener(RowFilterListener listener) throws TooManyListenersException {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        this.listener = listener;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.addRowFilterListener(listener);
        }
    }

    public final void removeRowFilterListener(RowFilterListener listener) {
        this.listener = null;
        if (this.pickListDataSet != null) {
            this.pickListDataSet.removeRowFilterListener(listener);
        }
    }

    public final void setDisplayOKCancel(boolean displayOKCancel) {
        if (this.lookupDialog != null) {
            this.lookupDialog.setDisplayOKCancel(displayOKCancel);
        }
        this.displayOKCancel = displayOKCancel;
    }

    public final boolean isDisplayOKCancel() {
        return this.displayOKCancel;
    }

    protected void loadPickList(PickListDescriptor pickList, Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int index;
            this.pickListDataSet = new DataSetView();
            if (this.listener != null) {
                if (this.pickListDataSet.getRowFilterListener() != null) {
                    this.pickListDataSet.removeRowFilterListener(this.pickListDataSet.getRowFilterListener());
                }
                this.pickListDataSet.addRowFilterListener(this.listener);
            }
            this.pickListDataSet.setStorageDataSet(pickList.getPickListDataSet().getStorageDataSet());
            this.sourceColumns = pickList.getPickListColumns();
            this.targetColumns = pickList.getDestinationColumns();
            this.displayColumns = pickList.getPickListDisplayColumns();
            if (this.sourceColumns == null || this.sourceColumns.length == 0 || this.targetColumns == null || this.targetColumns.length == 0 || this.displayColumns == null || this.displayColumns.length == 0) {
                this.pickListDataSet = null;
                component.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            this.pickListDataSet.open();
            this.locateRow = new DataRow((DataSet)this.pickListDataSet, this.sourceColumns);
            this.pickListColumns = pickList.getPickListDataSet().getStorageDataSet().getColumns();
            this.columnOriginalState = new int[this.pickListColumns.length];
            this.columnDialogState = new int[this.pickListColumns.length];
            for (index = 0; index < this.pickListColumns.length; ++index) {
                this.columnOriginalState[index] = this.pickListColumns[index].getVisible();
                this.pickListColumns[index].setVisible(0);
            }
            for (index = 0; index < this.displayColumns.length; ++index) {
                pickList.getPickListDataSet().getStorageDataSet().getColumn(this.displayColumns[index]).setVisible(1);
            }
            for (index = 0; index < this.pickListColumns.length; ++index) {
                this.columnDialogState[index] = this.pickListColumns[index].getVisible();
            }
            this.gridControl.setDataSet(this.pickListDataSet);
            this.gridControl.setReadOnly(true);
            this.gridControl.setMultiSelect(false);
            this.gridControl.setRowHeaderVisible(false);
            this.gridControl.setNavigateOnEnter(false);
            Frame frame = null;
            Component parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof Frame)) continue;
                frame = (Frame)parent;
                break;
            }
            if (frame == null) {
                frame = new Frame();
            }
            this.lookupDialog = new LookupDialog(frame, this.gridControl, this.allowSearch, this.alwaysCenter, this.displayOKCancel);
            this.lookupDialog.setTitle(this.windowTitle);
        }
        catch (Exception ex) {
            this.pickListDataSet = null;
            DataSetModel.handleException(component, ex, true);
        }
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Object getValue() {
        if (this.pickListDataSet != null && this.lookupDialog != null && !this.lookupDialog.useValue()) {
            return this.value;
        }
        return this.pickListDataSet;
    }

    public Component getComponent() {
        return null;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        Column currentColumn = null;
        ColumnVariant currentColumnVariant = null;
        if (data instanceof ColumnVariant) {
            currentColumnVariant = (ColumnVariant)data;
            this.value.setVariant(currentColumnVariant);
            currentColumn = currentColumnVariant.getColumn();
            this.currentColumnName = currentColumn.getColumnName();
            this.targetDataSet = currentColumnVariant.getDataSet();
            if (this.pickListDataSet == null || !this.pickListDataSet.isCompatibleList(this.locateRow)) {
                this.loadPickList(currentColumn.getPickList(), editSite.getSiteComponent());
            }
            if (this.pickListDataSet == null) {
                editSite.safeEndEdit(false);
                return;
            }
            if (this.listener != null) {
                try {
                    this.pickListDataSet.refilter();
                }
                catch (DataSetException ex) {
                    DataSetModel.handleException(this.gridControl, ex, true);
                }
            }
        }
        if (this.pickListDataSet != null && this.locateRow != null) {
            try {
                currentColumnVariant.getDataSet();
                DataSet.copyTo(this.targetColumns, currentColumnVariant.getDataSet(), this.sourceColumns, this.locateRow);
                this.pickListDataSet.locate(this.locateRow, 32);
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.gridControl, ex, true);
            }
        }
        try {
            int index;
            for (index = 0; index < this.pickListColumns.length; ++index) {
                this.pickListColumns[index].setVisible(this.columnDialogState[index]);
            }
            this.lookupDialog.show();
            for (index = 0; index < this.pickListColumns.length; ++index) {
                this.pickListColumns[index].setVisible(this.columnOriginalState[index]);
            }
        }
        catch (DataSetException ex) {
            DataSetModel.handleException(this.gridControl, ex, true);
        }
        editSite.safeEndEdit(this.lookupDialog.useValue());
    }

    public void changeBounds(Rectangle bounds) {
    }

    public boolean canPost() {
        return true;
    }

    public void endEdit(boolean post) {
    }

    public void addKeyListener(KeyListener l2) {
    }

    public void removeKeyListener(KeyListener l2) {
    }
}

