/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingletonDataSetManager;
import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FieldView;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.Serializable;

public class FieldControl
extends FieldView
implements DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox,
ColumnAware,
Serializable {
    protected DataSet dataSet;
    protected String columnName;
    protected boolean addNotifyCalled = false;
    protected String textureName;

    public FieldControl() {
        this.setDefaultLayout();
    }

    public synchronized String getText() {
        Object data = this.get();
        return data != null ? data.toString() : "";
    }

    public synchronized void setText(String text) {
        if (this.canSet(true)) {
            this.set(text);
        }
    }

    public void setModel(SingletonModel model) {
        if (model == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(model);
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    event.appendException(ex);
                }
                break;
            }
            case 2: {
                this.safeEndEdit(false);
                this.setDefaultLayout();
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.setDefaultLayout();
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, ex);
                this.setDefaultLayout();
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void bindDataSet() {
        Column column;
        this.safeEndEdit(false);
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            SingletonDataSetManager cursorManager = new SingletonDataSetManager(this.dataSet, column, this);
            this.setModel(cursorManager);
            this.setViewManager(cursorManager);
            this.bindProperties(column);
        }
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f2 = column.getFont();
        int a2 = column.getAlignment();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f2 != null) {
            this.setFont(f2);
        }
        if (a2 != 0) {
            this.setAlignment(a2);
        }
    }

    public void dataChanged(DataChangeEvent e2) {
    }

    public void postRow(DataChangeEvent e2) throws Exception {
        this.endEdit();
    }

    protected void processKeyPressed(KeyEvent e2) {
        super.processKeyPressed(e2);
        if (e2.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (e2.getKeyCode()) {
                case 155: {
                    this.dataSet.insertRow(false);
                    break;
                }
                case 127: {
                    if (e2.isControlDown()) {
                        this.dataSet.deleteRow();
                    }
                    break;
                }
                case 34: {
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    private void setDefaultLayout() {
        this.setModel(new BasicSingletonContainer());
        this.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter(this.getAlignment()))), new TextItemEditor(this.getAlignment())));
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean startEdit) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(startEdit) : false;
    }

    public void set(Object data) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(data);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean enable) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(enable);
        }
    }
}

