/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicSingletonContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.Pair;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.ButtonView;
import com.borland.jbcl.view.CompositeItemPainter;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ImageItemPainter;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class ButtonControl
extends ButtonView
implements BlackBox,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient Image image;
    protected int orientation;
    protected boolean imageFirst = true;
    protected URL url;
    protected String imageName;
    protected String label;
    protected String textureName;

    public ButtonControl() {
        this.setModel(new BasicSingletonContainer());
        this.setupPainters();
    }

    public ButtonControl(String label) {
        this();
        this.setLabel(label);
    }

    public ButtonControl(Image image) {
        this();
        this.setImage(image);
    }

    public ButtonControl(String label, Image image) {
        this();
        this.setLabel(label);
        this.setImage(image);
    }

    public void setOrientation(int o2) {
        this.orientation = o2;
        this.setupPainters();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setImageFirst(boolean first) {
        this.imageFirst = first;
        this.setupPainters();
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setLabel(String l2) {
        this.label = l2;
        this.setupPainters();
        this.invalidate();
        this.repaint(50L);
    }

    public String getLabel() {
        return this.label;
    }

    public void setImage(Image image) {
        this.setImage(image, "");
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageURL(URL url) {
        this.url = url;
        this.setImage(ImageLoader.load(url, (Component)this), url.toString());
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageName(String name) {
        Image image = null;
        if (name != null) {
            ImageLoader.loadFromResource(name, this);
            if (image == null) {
                try {
                    image = ImageLoader.load(new URL(name), (Component)this);
                }
                catch (MalformedURLException e2) {
                    image = ImageLoader.load(name, (Component)this);
                }
            }
        }
        this.setImage(image, name);
    }

    public String getImageName() {
        return this.imageName;
    }

    protected void setImage(Image im, String path) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res._ReadOnlySet);
        }
        if (im != null) {
            this.prepareImage(im, this);
        }
        this.image = im;
        this.imageName = path;
        this.getWriteModel().set(this.image);
        this.setupPainters();
    }

    public boolean imageUpdate(Image im, int flags, int x2, int y2, int w2, int h2) {
        if ((flags & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(im, flags, x2, y2, w2, h2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    private void setupPainters() {
        ImageItemPainter imagePainter = this.image != null ? new ImageItemPainter(this, this.getAlignment()) : null;
        FocusableItemPainter labelPainter = new FocusableItemPainter(new TextItemPainter(this.getAlignment(), new Insets(1, 1, 1, 1)), false);
        Serializable painter = null;
        Object data = null;
        if (this.image == null) {
            painter = labelPainter;
            data = this.label;
        } else if (this.image != null && this.label == null) {
            painter = new FocusableItemPainter(imagePainter, false);
            data = this.image;
        } else if (this.image != null && this.label != null) {
            Serializable secondPainter;
            Serializable firstPainter;
            if (this.imageFirst) {
                firstPainter = imagePainter;
                secondPainter = labelPainter;
                data = new Pair(this.image, this.label);
            } else {
                firstPainter = labelPainter;
                secondPainter = imagePainter;
                data = new Pair(this.label, this.image);
            }
            painter = new CompositeItemPainter((ItemPainter)((Object)firstPainter), (ItemPainter)((Object)secondPainter), this.orientation, this.getAlignment());
        }
        this.setViewManager(new BasicViewManager((ItemPainter)((Object)painter), null));
        if (!this.isReadOnly()) {
            this.getWriteModel().set(data);
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.image != null ? SerializableImage.create(this.image) : null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof SerializableImage) {
            this.image = ((SerializableImage)data).getImage();
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

