/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dx.text;

import com.borland.dx.dataset.Variant;
import com.borland.dx.text.IntegerFormatter;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.Res;
import com.borland.dx.text.VariantFormatter;
import java.io.Serializable;

public class ShortFormatter
extends IntegerFormatter
implements Serializable {
    public final void parse(Variant variant, char[] cArray, int n2, int n3) throws InvalidFormatException {
        if (cArray == null || n3 == 0 || cArray.length == 0) {
            variant.setUnassignedNull();
            return;
        }
        boolean bl = cArray[n2] == '-';
        int n4 = 0;
        if (bl) {
            ++n2;
            --n3;
        }
        int n5 = n2;
        while (n3 > 0) {
            int n6 = cArray[n5];
            if (n6 >= 48 && n6 <= 57) {
                n6 -= 48;
            } else if ((n6 = Character.digit((char)n6, 10)) < 0) {
                throw new InvalidFormatException(new String(cArray, n2, n3));
            }
            n4 = n4 * 10 + n6;
            ++n5;
            --n3;
        }
        int n7 = n5 = bl ? -n4 : n4;
        if (n5 > Short.MAX_VALUE || n5 < Short.MIN_VALUE) {
            throw new InvalidFormatException(Res.a.getString(4));
        }
        VariantFormatter.setFromInt(variant, this.type, n5);
    }

    public final void parse(String string, Variant variant) throws InvalidFormatException {
        if (string == null || (string = string.trim()).length() == 0) {
            variant.setUnassignedNull();
            return;
        }
        int n2 = 32768;
        try {
            n2 = Integer.parseInt(string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            if (!string.equals(numberFormatException.getMessage())) {
                throw new InvalidFormatException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Res.a.getString(8)))).append(": ").append(string).append(": ").append(numberFormatException.getMessage()))));
            }
            throw new InvalidFormatException(string);
        }
        if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
            throw new InvalidFormatException(Res.a.getString(4));
        }
        VariantFormatter.setFromInt(variant, this.type, n2);
    }

    public ShortFormatter(int n2) {
        super(n2);
    }
}

