package es.uvigo.esei.daa.rest;

import es.uvigo.esei.daa.dao.PetsDAO;
import es.uvigo.esei.daa.entities.Pet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import javax.ws.rs.core.Response;

import static es.uvigo.esei.daa.dataset.PetsDataset.existentPet;
import static es.uvigo.esei.daa.matchers.HasHttpStatus.hasOkStatus;
import static es.uvigo.esei.daa.matchers.IsEqualToPet.equalsToPet;
import static org.easymock.EasyMock.*;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

public class PetsResourceUnitTest {
    private PetsDAO daoMock;
    private PetsResource resource;


    @Before
    public void setUp() throws Exception {
        daoMock = createMock(PetsDAO.class);
        resource = new PetsResource(daoMock);
    }

    @After
    public void tearDown() throws Exception {
        try {
            verify(daoMock);
        } finally {
            daoMock = null;
            resource = null;
        }
    }


    @Test
    public void testGet() throws Exception {
        final Pet pet = existentPet();

        expect(daoMock.get(pet.getId())).andReturn(pet);

        replay(daoMock);

        final Response response = resource.get(pet.getId());

        assertThat(response, hasOkStatus());
        assertThat((Pet) response.getEntity(), is(equalsToPet(pet)));
    }


}
