/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator.adapters;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import es.uvigo.esei.dai.ws.calculator.Operation;

public class NamedOperationsMap {
	private List<NamedOperationsEntry> entries;
	
	public NamedOperationsMap() {
		this.entries = new LinkedList<NamedOperationsEntry>();
	}

	public NamedOperationsMap(Map<String, Operation> map) {
		this();
		
		for (Map.Entry<String, Operation> entry : map.entrySet()) {
			this.entries.add(new NamedOperationsEntry(entry));
		}
	}
	
	public Map<String, Operation> createMap() {
		final Map<String, Operation> map = new HashMap<String, Operation>();
		
		for (NamedOperationsEntry entry : this.entries) {
			map.put(entry.getKey(), entry.getValue());
		}
		
		return map;
	}

	public List<NamedOperationsEntry> getEntries() {
		return entries;
	}

	public void setEntries(List<NamedOperationsEntry> entries) {
		this.entries = entries;
	}
}
