/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator;

public enum Operation {
	ADD, SUB, MUL, DIV;
	
	public double calculate(double op1, double op2)
	throws CalculatorException {
		switch(this) {
		case ADD: return op1 + op2;
		case SUB: return op1 - op2;
		case MUL: return op1 * op2;
		case DIV: 
			if (op2 == 0d) {
				throw new CalculatorException(
					"op2 can't be zero", "op2 can't be zero"
				);
			} else {
				return op1 / op2;
			}
		default:
			throw new CalculatorException(
				"Unknown operation: " + this,
				"Unknown operation: " + this
			);
		}
	}
}
