/*-
 * #%L
 * Ejemplos de DAI - Servicios Web: Calculator Service
 * %%
 * Copyright (C) 2014 - 2025 Miguel Reboiro Jato
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package es.uvigo.esei.dai.ws.calculator;

import java.util.Collection;

import es.uvigo.esei.dai.ws.calculator.adapters.NamedOperations;
import es.uvigo.esei.dai.ws.calculator.adapters.NamedResults;
import jakarta.jws.WebMethod;
import jakarta.jws.WebService;

@WebService
public interface CalculatorService {
	@WebMethod
	public double add(double op1, double op2);
	
	@WebMethod
	public double subtract(double op1, double op2);
	
	@WebMethod
	public double multiply(double op1, double op2);
	
	@WebMethod
	public double divide(double op1, double op2)
	throws CalculatorException;
	
	@WebMethod
	public double operate(Operation operation, double op1, double op2)
	throws CalculatorException;
	
	@WebMethod
	public double serialOperate(Operation operation, double ... op)
	throws CalculatorException;
	
	@WebMethod
	public double arrayOperate(Operation operation, double[] op)
	throws CalculatorException;
	
	@WebMethod
	public double listOperate(Operation operation, Collection<Double> op)
	throws CalculatorException;
	
	/*
	 * JAXB no soporta esta declaración de método porque hace uso de Map,
	 * que es una interfaz y JAXB no es capaz de trabajar con interfaces
	 * directamente.
	 *
	 * @WebMethod
	 * public Map<String, Double> mapOperate(
	 * 		Map<String, Operation> operations, double op1, double op2
	 * ) throws CalculatorException;
	 */
	
	@WebMethod
	public NamedResults mapOperate(
		NamedOperations operations, double op1, double op2
	) throws CalculatorException;
}
